#include "exerciseshulte.h"

#include <QVBoxLayout>
#include <QFont>
#include <QPushButton>
#include <QFormLayout>
#include <QSpinBox>

ExerciseShulte::ExerciseShulte(QWidget *parent) :
        Exercise(parent)
{
    QVBoxLayout *vbLayout = new QVBoxLayout;

    m_shulte.setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);

    m_lblExerciseInfo.setSizePolicy(QSizePolicy::Preferred,QSizePolicy::MinimumExpanding);
    m_lblExerciseInfo.setGeometry(geometry());
    m_lblExerciseInfo.setAlignment(Qt::AlignJustify|Qt::AlignTop);
    m_lblExerciseInfo.setWordWrap(true);

    vbLayout->addWidget(&m_shulte);
    vbLayout->addWidget(&m_lblExerciseInfo);

    setLayout(vbLayout);

    showExerciseInfo();

    generateSettings();

    m_activeState = false;
}

void ExerciseShulte::showExerciseInfo(){
    m_shulte.hide();

    QString info = "<b>"+tr("Shulte's Table will help you to improve peripheral vision")+"</b><br><br>"+
                   tr("You will see the table with numbers. You have to search all numbers in the ascending order.")+"<br>"+
                   tr("Try to keep your eyes on the green point in the center of the table. This will help you to improve your peripheral vision and see a block of text without eye movements.")+"<br>"+
                   tr("Tap to screen or press \"Start\" button to start.");

    m_lblExerciseInfo.setText(info);

    m_lblExerciseInfo.show();
}

QWidget* ExerciseShulte::settingsWidget(){
    return &m_settingsWidget;
}

bool ExerciseShulte::advancedMode(){
    return false;
}

void ExerciseShulte::start(){
    m_lblExerciseInfo.hide();
    m_shulte.generateNew();
    m_shulte.show();
    m_activeState = true;
}

void ExerciseShulte::stop(){
    showExerciseInfo();
    m_activeState = false;
}

void ExerciseShulte::pause(){
    showExerciseInfo();
    m_activeState = false;
}

void ExerciseShulte::zoomIn(){
    QFont font(m_shulte.font());
    int i=font.pointSize();
    if (i<24) {
        font.setPointSize(++i);

        m_shulte.setFont(font);
        emit minZoomExceed(false);
        if (i>=24)
            emit maxZoomExceed(true);
    } else
        emit maxZoomExceed(true);
}

void ExerciseShulte::zoomOut(){
    QFont font(m_shulte.font());
    int i=font.pointSize();
    if (i>8){
        font.setPointSize(--i);

        m_shulte.setFont(font);
        emit maxZoomExceed(false);
        if (i<=8)
            emit minZoomExceed(true);
    } else
        emit minZoomExceed(true);
}

void ExerciseShulte::mousePressEvent(QMouseEvent *){
    emit clicked();
}

void ExerciseShulte::generateSettings(){
    m_settingsWidget.setAutoFillBackground(true);

    QFormLayout *formLayout = new QFormLayout;

    QLabel *lbl = new QLabel("<b>"+tr("Settings of Shulte\'s table exercise")+"</b>");

    formLayout->addRow(lbl);

    QSpinBox *sb = new QSpinBox;
    sb->setMinimum(3);
    sb->setMaximum(7);
    sb->setValue(m_shulte.rowsCount());
    connect(sb,SIGNAL(valueChanged(int)),this,SLOT(setRowsCount(int)));
    formLayout->addRow(tr("Table size:"),sb);

    QPushButton *btn = new QPushButton(tr("OK"));
    btn->setIcon(QIcon::fromTheme("window-close", QIcon(":/img/ok.png")));
    connect(btn,SIGNAL(clicked()),&m_settingsWidget,SLOT(hide()));

    formLayout->addWidget(btn);

    m_settingsWidget.setLayout(formLayout);
}

void ExerciseShulte::resizeEvent(QResizeEvent *event){
    QWidget::resizeEvent(event);
    if (parent()!=NULL){
        QSize s=parentWidget()->size();
        m_settingsWidget.setGeometry(0,0,s.width(),s.height());
    }
}

bool ExerciseShulte::isActive(){
    return m_activeState;
}

int ExerciseShulte::mode(){
    return Exercise::Shulte;
}

void ExerciseShulte::setRowsCount(int n){
    m_shulte.setRowsCount(n);
}
