#ifndef ExerciseClassic_H
#define ExerciseClassic_H

#include "exercise.h"
#include "plaintextviewer.h"

#include <QLabel>
#include <QTimer>
#include <QScrollArea>

struct ExerciseClassicSettings {
    int minSpeed;
    int maxSpeed;
    bool accelerate;
    int type;
    ExerciseClassicSettings(): minSpeed(60),maxSpeed(300),accelerate(false),type(0) {};
};

class ExerciseClassic: public Exercise
{
Q_OBJECT
public:
    ExerciseClassic(QWidget *parent = 0);
    QWidget* settingsWidget();
    bool advancedMode();
    void setText(QString&);
    void showExerciseInfo();
    bool isEmptyText();
    bool isActive();
    int maxProgress();
    int speed();
    int mode();
    enum Type {Points=0,Shutter,Page};
protected:
    void mousePressEvent(QMouseEvent *);
    void resizeEvent(QResizeEvent *);

public slots:
    void start();
    void stop();
    void tick();
    void zoomIn();
    void zoomOut();
    void faster();
    void slower();
    void pause();
    void setOffset(int);

private slots:
    void setMinSpeed(int);
    void setMaxSpeed(int);
    void setAccelerate(bool);
    void setTypePoints();
    void setTypeShutter();
    void setTypePage();

private:
    void generateSettings();

    QScrollArea m_settingsWidget;
    int m_currentPos;
    QLabel m_lblExerciseInfo;
    int m_interval;
    ExerciseClassicSettings m_settings;
    QTimer m_timer;
    PlainTextViewer *m_plainTextViewer;
    int m_textLineHeight;
    int m_textLineVisibleNumber;
    int m_textLineTotalNumber;
    QLabel m_lblPause;
    QPixmap m_pxmGreenPoint;
    QLabel m_lblGreenPoint;
    int m_linesHandled;
    QLabel m_lblShutter;
};

#endif // ExerciseClassic_H
