/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UIVIEW_H_
#define _UIVIEW_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include "ui.h"

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

GString *get_column_header(gint col);
GString *get_column_header_one_line(gint col);
void update_record_model(AppUIData *pui);
void sort_order_ascending_callback( GtkAction * action, AppUIData *pui );
void sort_order_descending_callback( GtkAction * action, AppUIData *pui );
void callback_select_sortcolumn(GtkWidget *widget, AppUIData *pui );
GtkTreeModel *create_and_fill_model (void);
GtkWidget *create_view_and_model (void);

#endif
