/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UISETTINGS_H_
#define _UISETTINGS_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "ui.h"

/*******************************************************************
 *
 * Public defines
 *
 *******************************************************************/

/* Which columns are displayed by default (a bitfield) */
#define DISPCOLDEFAULT (1<<COL_NOTES | 1<<COL_NOTES | 0 << COL_TIRES | 0 << COL_OIL | 0 << COL_SERVICE | 0 << COL_PRICEPERLITRE | 1 << COL_PRICEPERTRIP | 1 << COL_PRICE | 1 << COL_CONSUM | 1 << COL_FILL | 1 << COL_TRIP | 1 << COL_KM | 1 << COL_DAY)

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

extern double warnkm;
extern double warndays;
extern enum papertype reportpaper;
extern enum userinterfacestyle uistyle;
extern gint dispcol;
extern char *datefmtstr[];
extern enum fontscale fontsize;
extern double fontscalefactors[];
gboolean autostartGPS;
gboolean autostartnetwork;
double locationaliasradius;

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

gint sizeofdatefmtstr(void);
#if MAEMO_VERSION_MAJOR == 5
GtkWidget *create_unit_combo(gint whichunit, AppUIData *pui, GtkWidget *button);
#else
GtkWidget *create_unit_combo(gint whichunit, AppUIData *pui);
#endif
void callback_select_columns( GtkAction * action, AppUIData *pui );
void callback_settings( GtkAction * action, AppUIData *pui );

#endif
