/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007, 2008 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/**
 *
 * \file
 * \brief  Utility functions to fuelpad
 * \author Julius Luukko
 *
 *
 */

#ifndef _UTIL_H_
#define _UTIL_H_

void convdate(char **s, const char *outformat, 
	      const char *informat, const char *date);
void date2sqlite(char **s, const char *format, const char *date);
void gettimefmt(char **aika, const char *format);
void gettime(char **aika);
int getyear(void);
void getyearmonthday(const char *datestr, int *year, int *month, int *day);
double doubleornothing(double input);

#endif
