#include <QMainWindow>
#include <QComboBox>
#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QFont>
#include <QHBoxLayout>
#include <QSignalMapper>
#include <assert.h>
#include <sys/time.h>
#include <time.h>
#include <math.h>
#include <string>
#include <sstream>
#include <iostream>
#include <fstream>
#include "sudoku.hpp"
#include <getopt.h>


extern char* optarg;
extern int optind, opterr, optopt;

using namespace std;

class fSudoku {
private:
public:
	fSudoku();
	void init();
	sudoku *a;
	void newSudoku(int level);
	char base[9][9];
	char unsolved[9][9];
	char solved[9][9];
	bool game;
	void save();
	void load();
	void solve();
	bool isValid(int x, int y);
	int unfilled;
	string candidates[9][9];
	int timeTimer;
	struct step {
		int x;
		int y;
		char value[2];
		QString color;
		QFont font;
		string candidates;
		int unfilled;
	};
	step *undo;
	step *redo;
	void nullUndo();
	void nullRedo();
};

class Main : public QMainWindow {
	Q_OBJECT

public:
	Main();
	void init();
	void setGameField(int mode);//mode: 0->New Game 1->Load Game 2->Custom Game
	void setControl();
    QLabel *timeLabel;
    QLabel *unfilledCounterLabel;
    fSudoku *fSudo;
    int vLevel;
    QPushButton *elements[9][9];
    char cacheCharSmall[2];
    void saveUndo(int x, int y, char value, QString color, QFont font, string candidates, int unfilled);
    void saveRedo(int x, int y, char value, QString color, QFont font, string candidates, int unfilled);

public slots:
	void updateTimer();
	void setElement(int value);
	void undo();
	void redo();
	void solve();
	void oneChecked(QWidget* element);
	void addCandidate();
	void newGame();
	void setLevel();
	void loadGame();
	void loadCustomGame();
	void saveToFile();
	void customGame();

protected:


private:
	QWidget * master;
	QWidget * slave;
	QGridLayout *grid;
	QTimer *timer;
    QSignalMapper *signalMapper;
    QSignalMapper *signalMapperGrid;
    QPushButton *control[11];
    QGridLayout *touchControl;
    QPushButton *undoButton;
    QPushButton *redoButton;
    QPushButton *solveButton;
    QPushButton *candidateButton;
    QFont defaultFont;
    QFont candidateFont;
    QString defaultStyle;
    QHBoxLayout *mainLayout;
    QComboBox * level;
    QLabel *xy;
    bool running;
};

class Window : public QMainWindow
{
	Q_OBJECT

public:
	Window();
};
