/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef TP_STATUS_FEED_PRIVATE_H_
#define TP_STATUS_FEED_PRIVATE_H_

#ifndef TP_STATUS_FEED_H_
#error Do not include this file directly.
#endif /* TP_STATUS_FEED_H_ */

#define TP_STATUS_FEED_GET_PRIVATE(o) \
            ((TpStatusFeedPrivate *)       \
            ((TpStatusFeed *)(o))->priv)

typedef struct _TpStatusFeedPrivate TpStatusFeedPrivate;
struct _TpStatusFeedPrivate
{
  HildonProgram *program;

  /* Window stack */
  HildonWindowStack *stack;

  /* Windows */
  struct {
    GtkWidget *window;

    GtkWidget *friend_view;
    GtkWidget *group_button;
    GtkWidget *abook_button;
    RTComElQueryGroupBy group_by;

    GtkWidget *me_view;
    GtkWidget *me_view_vbox;
    GtkWidget *update_button;
    GtkWidget *me_history_view;
  } main_status;

  struct {
    GtkWidget *window;
    GtkWidget *view;
  } contact_status;

  /* Menus */
  struct {
    GtkWidget *menu;

    /* Menu filters */
    GtkWidget *friend_filter;
    GtkWidget *me_filter;

    /* Menu items */
    GtkWidget *delete;
    GtkWidget *settings;
    GtkWidget *accounts;
    GtkWidget *backup;
    GtkWidget *about;
  } main_menu;

  struct {
    GtkWidget *menu;

    /* Menu items */
    GtkWidget *delete;
  } contact_menu;

  OssoABookSelfContact *self_contact;
  RTComEl *eventlogger; /* for logging status update in the backend */
  OssoABookRoster *aggregator; /* default addressbook aggregator */
  osso_context_t *osso_context;
  gboolean friends_flag; /* TRUE if main view shows friends status*/

  gint last_friend_status_id;
  gint last_my_status_id;
};

#endif /* TP_STATUS_FEED_PRIVATE_H_ */
