/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DELETE_STATUS_WINDOW_H_
#define DELETE_STATUS_WINDOW_H_

#include <gtk/gtk.h>
#include <hildon/hildon-stackable-window.h>

G_BEGIN_DECLS

#define DELETE_TYPE_STATUS_WINDOW            (delete_status_window_get_type ())
#define DELETE_STATUS_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                              DELETE_TYPE_STATUS_WINDOW, DeleteStatusWindow))
#define DELETE_STATUS_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                              DELETE_TYPE_STATUS_WINDOW, DeleteStatusWindowClass))
#define DELETE_IS_STATUS_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                              DELETE_TYPE_STATUS_WINDOW))
#define DELETE_IS_STATUS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                              DELETE_TYPE_STATUS_WINDOW))
#define DELETE_STATUS_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                              DELETE_TYPE_STATUS_WINDOW, DeleteStatusWindowClass))

typedef struct _DeleteStatusWindow      DeleteStatusWindow;
typedef struct _DeleteStatusWindowClass DeleteStatusWindowClass;

struct _DeleteStatusWindow
{
  HildonStackableWindow parent;
  gpointer priv;
};

struct _DeleteStatusWindowClass
{
  HildonStackableWindowClass parent_class;
};

GType delete_status_window_get_type (void);

GtkWidget *delete_status_window_new (OssoABookRoster *aggregator);

void delete_status_window_populate_friends_status (DeleteStatusWindow *del_window);

void delete_status_window_populate_my_status (DeleteStatusWindow *del_window);

void delete_status_window_populate_contact_status (DeleteStatusWindow *del_window,
                                                   const gchar *account,
                                                   const gchar *contact);

G_END_DECLS

#endif /* DELETE_STATUS_WINDOW_H_ */
