/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef CONTACT_STATUS_VIEW_H_
#define CONTACT_STATUS_VIEW_H_

G_BEGIN_DECLS

#define CONTACT_TYPE_STATUS_VIEW            (contact_status_view_get_type ())
#define CONTACT_STATUS_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                             CONTACT_TYPE_STATUS_VIEW, ContactStatusView))
#define CONTACT_STATUS_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                             CONTACT_TYPE_STATUS_VIEW, ContactStatusViewClass))
#define CONTACT_IS_STATUS_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                             CONTACT_TYPE_STATUS_VIEW))
#define CONTACT_IS_STATUS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                             CONTACT_TYPE_STATUS_VIEW))
#define CONTACT_STATUS_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                             CONTACT_TYPE_STATUS_VIEW, ContactStatusViewClass))

typedef struct _ContactStatusView      ContactStatusView;
typedef struct _ContactStatusViewClass ContactStatusViewClass;

struct _ContactStatusView
{
  GtkAlignment parent;
  gpointer priv;
};

struct _ContactStatusViewClass
{
  GtkAlignmentClass parent_class;
};

GType contact_status_view_get_type (void);

GtkWidget *contact_status_view_new (void);

const gchar *contact_status_view_get_contact_im_field (ContactStatusView *view);

const gchar *contact_status_view_get_contact_account (ContactStatusView *view);

void contact_status_view_set_abook_aggregator (ContactStatusView *view,
                                               OssoABookRoster *aggr);

void contact_status_view_set_eventlogger (ContactStatusView *view,
                                          RTComEl *eventlogger);

void contact_status_view_update_contact (ContactStatusView *view,
                                         const gchar *local_account,
                                         gchar *remote_account,
                                         gchar *name,
                                         gchar *text,
                                         gchar *start_time,
                                         GdkPixbuf *service_icon);

void contact_status_view_refresh (ContactStatusView *view);

void contact_status_view_clean_history (ContactStatusView *view);

G_END_DECLS

#endif /* CONTACT_STATUS_VIEW_H_ */
