/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef CONTACT_HISTORY_VIEW_H_
#define CONTACT_HISTORY_VIEW_H_

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define CONTACT_TYPE_HISTORY_VIEW            (contact_history_view_get_type ())
#define CONTACT_HISTORY_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                             CONTACT_TYPE_HISTORY_VIEW, ContactHistoryView))
#define CONTACT_HISTORY_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                             CONTACT_TYPE_HISTORY_VIEW, ContactHistoryViewClass))
#define CONTACT_IS_HISTORY_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                             CONTACT_TYPE_HISTORY_VIEW))
#define CONTACT_IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                             CONTACT_TYPE_HISTORY_VIEW))
#define CONTACT_HISTORY_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                             CONTACT_TYPE_HISTORY_VIEW, ContactHistoryViewClass))

typedef struct _ContactHistoryView      ContactHistoryView;
typedef struct _ContactHistoryViewClass ContactHistoryViewClass;
typedef struct _HistoryStatus HistoryStatus;

struct _HistoryStatus
{
  guint event_id;
  gchar *status;
  gchar *timestamp;

  ContactHistoryView *view;
};

struct _ContactHistoryView
{
  GtkVBox parent;
  gpointer priv;
};

struct _ContactHistoryViewClass
{
  GtkVBoxClass parent_class;
};

GType contact_history_view_get_type (void);

GtkWidget *contact_history_view_new (void);

void
contact_history_view_set_eventlogger (ContactHistoryView *view,
                                      RTComEl *eventlogger);

void
contact_history_view_update_contact (ContactHistoryView *view,
                                     const gchar *local_uid,
                                     const gchar *remote_uid);

G_END_DECLS


#endif /* CONTACT_HISTORY_VIEW_H_ */
