/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

#include "common.h"

const gchar *
get_secondary_text_color()
{
  static gchar buf[40] = {0};

  if (G_UNLIKELY (buf[0] == '\0')) {
    GdkColor color;
    GtkStyle *style = gtk_rc_get_style_by_paths (gtk_settings_get_default (),
                                                 NULL, NULL, GTK_TYPE_LABEL);

    if (gtk_style_lookup_color (style, "SecondaryTextColor", &color))
        sprintf(buf, "#%02x%02x%02x", color.red / 256,
                color.green / 256, color.blue / 256);
  }

  return buf;
}

static gchar *
_calculate_time (time_t t,
                 gboolean is_full)
{
  gchar res[40] = {0};
  time_t current;
  struct tm *current_time, *timestamp;
  int year, month, day;

  current = time (NULL);
  current_time = localtime (&current);
  year = current_time->tm_year;
  day = current_time->tm_mday;
  month = current_time->tm_mon;

  timestamp = localtime (&t);

  if (!is_full &&
      (timestamp->tm_year == year) &&
      (timestamp->tm_mon == month) &&
      (timestamp->tm_mday == day)) {
    strftime (res, sizeof (res), "%T", timestamp);
  }
  else
    strftime (res, sizeof (res), "%Y.%m.%d", timestamp);

  return g_strdup (res);
}

gchar *
get_timestamp (time_t t)
{
  return _calculate_time (t, FALSE);
}

gchar *
get_timestamp_full (time_t t)
{
  return _calculate_time (t, TRUE);
}
