/**
 * Source file from libuiw, which is under LGPL v2.1 license
 * http://repository.maemo.org/catalogue/certified/pool/diablo/user/libu/libuiw/
 *
 * @file urllabel.h
 */

#ifndef _URL_LABEL_H
#define _URL_LABEL_H

#include <glib-object.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS
#define TYPE_URL_LABEL              (url_label_get_type ())
#define URL_LABEL(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), TYPE_URL_LABEL, UrlLabel))
#define URL_LABEL_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_LABEL, UrlLabelClass))
#define IS_URL_LABEL(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), TYPE_URL_LABEL))
#define IS_URL_LABEL_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_LABEL))
#define URL_LABEL_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_LABEL, UrlLabelClass))

typedef struct _UrlLabel UrlLabel;
typedef struct _UrlLabelClass UrlLabelClass;

/** UrlLabel object */
struct _UrlLabel {
  GtkLabel parent;
};

/** UrlLabel class */
struct _UrlLabelClass {
  GtkLabelClass parent_class;

  void (*url_clicked)(UrlLabel *url_label, const gchar *url);
};

GType url_label_get_type(void) G_GNUC_CONST;

GtkWidget *url_label_new();
void url_label_set_text(UrlLabel *label, gchar *text);

G_END_DECLS
#endif                          /* _URL_LABEL_H */
