/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ONE_STATUS_VIEW_H_
#define ONE_STATUS_VIEW_H_

#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define ONE_TYPE_STATUS_VIEW            (one_status_view_get_type ())
#define ONE_STATUS_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                             ONE_TYPE_STATUS_VIEW, OneStatusView))
#define ONE_STATUS_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                             ONE_TYPE_STATUS_VIEW, OneStatusViewClass))
#define ONE_IS_STATUS_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                             ONE_TYPE_STATUS_VIEW))
#define ONE_IS_STATUS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                             ONE_TYPE_STATUS_VIEW))
#define ONE_STATUS_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                             ONE_TYPE_STATUS_VIEW, OneStatusViewClass))

typedef struct _OneStatusView      OneStatusView;
typedef struct _OneStatusViewClass OneStatusViewClass;

struct _OneStatusView
{
  GtkAlignment parent;
  gpointer priv;
};

struct _OneStatusViewClass
{
  GtkAlignmentClass parent_class;
};

GType one_status_view_get_type (void);

GtkWidget *one_status_view_new (void);

const gchar *one_status_view_get_status_text (OneStatusView *view);

void one_status_view_update_contact (OneStatusView *view,
                                     OssoABookContact *contact,
                                     gchar *text,
                                     gchar *start_time,
                                     const GdkPixbuf *service_icon);

void one_status_view_set_event_id (OneStatusView *view,
                                   gint event_id);

gint
one_status_view_get_event_id (OneStatusView *view);

G_END_DECLS

#endif /* ONE_STATUS_VIEW_H_ */
