/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef TIMELINE_VIEW_H_
#define TIMELINE_VIEW_H_

#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define TIMELINE_TYPE_VIEW              (timeline_view_get_type ())
#define TIMELINE_VIEW(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                         TIMELINE_TYPE_VIEW, TimelineView))
#define TIMELINE_VIEW_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                         TIMELINE_TYPE_VIEW, TimelineViewClass))
#define TIMELINE_IS_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                         TIMELINE_TYPE_VIEW))
#define TIMELINE_IS_VIEW_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                         TIMELINE_TYPE_VIEW))
#define TIMELINE_VIEW_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                         TIMELINE_TYPE_VIEW, TimelineViewClass))

typedef struct _TimelineView      TimelineView;
typedef struct _TimelineViewClass TimelineViewClass;

struct _TimelineView
{
  GtkAlignment parent;
  gpointer     priv;
};

struct _TimelineViewClass
{
  GtkAlignmentClass parent_class;
};

typedef void (*TimelineViewSelectStatusCallback) (GtkTreeView *treeview,
                                                  GtkTreePath *path,
                                                  GtkTreeViewColumn *col,
                                                  gpointer userdata);
GType timeline_view_get_type (void);

GtkWidget *timeline_view_new (gboolean need_top_box);

GtkWidget *timeline_view_get_top_box (TimelineView *view);

GtkWidget *timeline_view_get_action_area_box (TimelineView *view);

void timeline_view_add_search_bar (TimelineView *view,
                                   GtkWidget *window);

void timeline_view_hide_search_bar (TimelineView *view);

void timeline_view_set_abook_aggregator (TimelineView *view,
                                         OssoABookRoster *aggregator);

RTComEl *timeline_view_get_eventlogger (TimelineView *view);

void timeline_view_set_select_status_cb (TimelineView *view,
                                         TimelineViewSelectStatusCallback cb,
                                         gpointer userdata);

/* Multiple selection mode for deleting statuses */
void timeline_view_set_mode_selection_multiple (TimelineView *view);

GtkTreeSelection *timeline_view_get_selection (TimelineView *view);

/* Populate statuses */

void timeline_view_populate_common_status (TimelineView *view,
                                           const gchar *eventtype);

/* Populate all my status history */
static inline void
timeline_view_populate_my_status (TimelineView *view)
{
  timeline_view_populate_common_status (view, "RTCOM_EL_EVENTTYPE_STATUS_MY");
}

/* Populate status history of all friends */
static inline void
timeline_view_populate_friends_status (TimelineView *view)
{
  timeline_view_populate_common_status (view, "RTCOM_EL_EVENTTYPE_STATUS_FRIEND");
}

void timeline_view_populate_all_status (TimelineView *view);

void timeline_view_populate_contact_status (TimelineView *view,
                                            const gchar *account,
                                            const gchar *contact);

void timeline_view_set_group_by (TimelineView *view,
                                 RTComElQueryGroupBy group_by);

void timeline_view_row_changed (TimelineView *view);

G_END_DECLS

#endif /* TIMELINE_VIEW_H_ */
