/**
 * Copyright (C) 2008-09 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>
#include <libosso.h>
#include <hildon/hildon-program.h>
#include <libosso-abook/osso-abook.h>

#include "tp-status-feed.h"

static TpStatusFeed *statusfeed = NULL;

int
main(int argc, char * argv[])
{
  osso_context_t *osso_context;

  gtk_init (&argc, &argv);

  osso_context = osso_initialize("org.maemo.friendstatus",
                                 "0.1", FALSE, NULL);

  /* Init abook */
  if (!osso_abook_init (&argc, &argv, osso_context)) {
      g_critical ("Error initializing libosso-abook");
      osso_deinitialize (osso_context);
      return 1;
  }

  statusfeed = tp_status_feed_get_instance ();
  tp_status_set_osso (statusfeed, osso_context);

  gtk_main();

  osso_deinitialize (osso_context);

  g_debug("Quitting!");
  return 0;
}
