#include "ffmwidget.h"
#include "ffmsettingsdialog.h"

FFMSettingsDialog::FFMSettingsDialog(FFMWidget * widget)
    : QDialog(widget)
    , mWidget(widget)
{
    ui.setupUi(this);
    if (mWidget && mWidget->isFMBoostActivated())
    {
        ui.boostCheckBox->setChecked(true);
    }
    else
    {
        ui.boostCheckBox->setChecked(false);
    }
}

void FFMSettingsDialog::updateUi()
{
    if (mWidget && mWidget->isFMBoostInstalled())
    {
        ui.boostCheckBox->setEnabled(true);
        ui.boostCheckBox->setText("Use FM Boost (installed)");
    }
    else
    {
        ui.boostCheckBox->setEnabled(false);
        ui.boostCheckBox->setText("Use FM Boost (not installed)");
    }
}

void FFMSettingsDialog::on_boostCheckBox_stateChanged(int state)
{
    emit fmBoostChanged(state);
}

