/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FFMBUTTON_H
#define FFMBUTTON_H

#include <QtGui>

class FFMButton : public QLabel
{
    Q_OBJECT
public:
    FFMButton(const char * backgroundPath, const char * backgroundPressedPath, QWidget *parent = 0);

signals:
    void clicked();

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);

    QPixmap mBackground;
    QPixmap mBackgroundPressed;
};

#endif // FFMBUTTON_H
