#include "TStudyFileParser.h"
#include "TCard.h"

#include <QtDebug>
#include <QUuid>
#include <QMessageBox>

//#define PRINT_REPETITIONDATA

TStudyFileParser::TStudyFileParser( TDictionary* aDict )
     : iDict( aDict ), iCurCard( NULL )
{
iErrorStr.clear();
iRootExists = iDict->CardsNum() > 0;
iDictField0Id = iDict->Field( 0 ).id;
iDictField1Id = iDict->Field( 1 ).id;
srand( time(NULL) );
}

bool TStudyFileParser::startElement(const QString& /* namespaceURI */, const QString& /* localName */,
                                const QString& qName, const QXmlAttributes& attributes)
{
if ( !iRootExists && qName != "study")
    {
    iErrorStr = QObject::tr("The parsed file is not study data");
    return false;
    }
if ( !iDict )
    {
    iErrorStr = "No dictionary";
    return false;
    }

if (qName == "c")
    {
    QString uuidStr = attributes.value("id");
    if( !uuidStr.isEmpty() )
        {
        QUuid id = QUuid( uuidStr );
        if( !id.isNull() )
            {
            iCurCard = iDict->FindCardByUuid( id );
            iCurCardIx = iDict->FindCardIxByUuid( id );
            return true;
            }
        }
    iCurCard = NULL;    // without UUID
    }
else if (qName == "s")
    {
    if( !iCurCard )
        return true;
        
    QString revStr = attributes.value("rev");
    QUuid defaultQstId;
    QUuid defaultAnsId;
    if( revStr == "yes" )  // reversed default
        {
        defaultQstId = iDictField1Id;
        defaultAnsId = iDictField0Id; 
        }
    else    // default
        {
        defaultQstId = iDictField0Id;
        defaultAnsId = iDictField1Id; 
        }
        
    QString qstUuidStr = attributes.value("qst");
    QUuid qstId;    // null
    
    if( !qstUuidStr.isEmpty() )
        {
        qstId = QUuid( qstUuidStr );
        if( qstId.isNull() )
            qstId = defaultQstId;
        }
    else
        qstId = defaultQstId;
    QString ansUuidStr = attributes.value("ans");
    QUuid ansId;    // null
    if( !ansUuidStr.isEmpty() )
        {
        ansId = QUuid( ansUuidStr );
        if( ansId.isNull() )
            ansId = defaultAnsId;
        }
    else
        ansId = defaultAnsId;
        
    int qstIx = iDict->FieldIdToIx( qstId );
    int ansIx = iDict->FieldIdToIx( ansId );
        
    TCard::TRepetition rep;
    rep.lastRepetition = QDateTime::fromString( attributes.value("last"), Qt::ISODate );
    rep.interval = attributes.value("int").toFloat();
    rep.grade = attributes.value("grd").toInt();
    rep.easiness = attributes.value("eas").toFloat();
    rep.afterCards = attributes.value("cards").toInt();
    iCurCard->SetRepetition( qMakePair( qstIx, ansIx ), rep );
    #ifdef PRINT_REPETITIONDATA
        PrintRepetitionData( iCurCardIx, qstIx, ansIx, rep );
    #endif
    }
else if (qName == "unrep")
    {
    /// @todo The same processing of reversed and default field ids as in tag "s". Put it to a separate function.   
    QString revStr = attributes.value("rev");
    QUuid defaultQstId;
    QUuid defaultAnsId;
    if( revStr == "yes" )  // reversed default
        {
        defaultQstId = iDictField1Id;
        defaultAnsId = iDictField0Id; 
        }
    else    // default
        {
        defaultQstId = iDictField0Id;
        defaultAnsId = iDictField1Id; 
        }
        
    QString qstUuidStr = attributes.value("qst");
    QUuid qstId;    // null
    
    if( !qstUuidStr.isEmpty() )
        {
        qstId = QUuid( qstUuidStr );
        if( qstId.isNull() )
            qstId = defaultQstId;
        }
    else
        qstId = defaultQstId;
    QString ansUuidStr = attributes.value("ans");
    QUuid ansId;    // null
    if( !ansUuidStr.isEmpty() )
        {
        ansId = QUuid( ansUuidStr );
        if( ansId.isNull() )
            ansId = defaultAnsId;
        }
    else
        ansId = defaultAnsId;
        
    int qstIx = iDict->FieldIdToIx( qstId );
    int ansIx = iDict->FieldIdToIx( ansId );
        
    TDictionary::TUnrepCardsData unrep;
    unrep.lastAddition = QDateTime::fromString( attributes.value("added"), Qt::ISODate );
    unrep.usedNum = attributes.value("used").toInt();
    iDict->iUnrepCardsData[ qMakePair( qstIx, ansIx ) ] = unrep;
    }
else if (qName == "study")
    {
    iRootExists = true;
    QString randomStr = attributes.value("random");
    if( randomStr == "yes" )
        {
        #ifdef PRINT_REPETITIONDATA
            qDebug( "=== Randomly generated study data ===");
        #endif
        for( int i = 0; i < iDict->CardsNum(); i++ )
            {
            TCard* card = iDict->Card( i );
            TCard::TRepetition rep;
            rep.lastRepetition = QDateTime::currentDateTime().addDays( -1 * ( rand() % 2 ) );
            rep.interval = rand() % 700 / 10.0 + 0.1;
            rep.grade = rand() % 6;
            rep.easiness = rand() % 20 / 10.0 + 1.3; // 1.3 .. 3.2
            card->SetCurRepetition( rep );
            TQstnAnsrPair curRepIx = card->CurRepetitionIx();
            #ifdef PRINT_REPETITIONDATA
                PrintRepetitionData( i, curRepIx.first, curRepIx.second, rep );
            #endif
            }
        #ifdef PRINT_REPETITIONDATA
            qDebug( "=== END of random data ===");
        #endif
        }
    }
return true;
}

void TStudyFileParser::PrintRepetitionData( int aCard, int aQst, int aAns, const TCard::TRepetition& aRep)
{
int dLastRep = QDateTime::currentDateTime().daysTo( aRep.lastRepetition );
qDebug( "rep[%d]: qst=%d ans=%d last=%s int=%d+%g grd=%d eas=%g cards=%d",
    aCard, aQst, aAns, (const char*)aRep.lastRepetition.toString("yyyy-MM-dd HH:mm:ss").toLatin1(),
    dLastRep, aRep.interval, aRep.grade, aRep.easiness, aRep.afterCards );
}

bool TStudyFileParser::fatalError(const QXmlParseException &exception)
{
iErrorStr = QObject::tr("XML parse error at line %1, column %2:\n"
    "%3.").arg(exception.lineNumber()).arg(exception.columnNumber())
    .arg(exception.message());
return false;
}
