#ifndef TSPACEDREPETITIONWINDOW_H
#define TSPACEDREPETITIONWINDOW_H

#include "MTestWindow.h"
#include "MSingleton.h"
#include "TSpacedRepetitionModel.h"

class QPushButton;
class QLabel;
class QCheckBox;
class QToolBar;
class QAction;
class QActionGroup;
class TSpacedRepetitionModel;
class QSignalMapper;

/// @todo Optimize the test window implementations, move common parts into the abstract MTestWindow. Is it needed, BTW?
class TSpacedRepetitionWindow: public MTestWindow, public MSingleton< TSpacedRepetitionWindow, TSpacedRepetitionModel >
{
Q_OBJECT

friend class MSingleton< TSpacedRepetitionWindow, TSpacedRepetitionModel >;

enum TTestState
    {
    ENoTestCards = 0,
    ENoCurCard,
    EAnswerHidden,
    EAnswerVisible,
    ENoAnswerHiddenExample,
    ENoAnswerVisibleExample
    };

protected:
// Cosntructor
TSpacedRepetitionWindow(TSpacedRepetitionModel* aModel, QWidget* parent = 0, Qt::WindowFlags flags = 0);

void ReadSettings();
void WriteSettings();
void CreateStatusBar();

protected slots:
void ToggleAnswer();
void SwitchToAnswerControls();
void SwitchToContinueControls();
void SwitchToNextControls();
void UpdateCardsNumLabels();

// From MTestWindow
void Update();
void UpdateDictName();
void UpdateCard( bool aNewCard = false );
void DisplayCardNum();
void UpdateButtons();

private:    // Methods
void CreateButtons();
void CreateCentralWidget();
QString ShortcutToStr( QKeySequence aShortcut );
QString ShortcutsToStr( QList< QKeySequence >& aShortcuts );
void SetAnswerMode( TTestState aState );
void SetQuestionMode( TTestState aState );
void ShowAnswer( bool aVisible );

private:    // Data

// Current card
QString iCurQuestion;
QString iCurAnswer;
TTestState iState;

// UI components
QLabel* iDicNameLabel;
QLabel* iDeadlineLabel;
QLabel* iQstnLabel;
QLabel* iAnsrLabel;
QLabel* iCardNumLabel;
QLabel* iValidCardsLabel;
QLabel* iUnrepCardsLabel;
QPushButton* iQuitBtn;

QSignalMapper* iSMCardGraded;
QPushButton* iAnswerBtn;
QPushButton* iGradeBtns[ TSpacedRepetitionModel::KGradesNum ];
QWidget* iAnswerGroup;   // Buttons "Answer" and grades

QPushButton* iNextBtn;  // Button "Next card", when the current card was removed
QWidget* iNextGroup;   // Button "Next card"

/// Take cards scheduled for the next day
QPushButton* iContinueBtn;
/// Take another day portion of unrepeated cards
QPushButton* iUnrepeatedBtn;
/// Check now for active cards
QPushButton* iUpdateBtn;
QPushButton* iSwapQstnAnsrBtn;
QWidget* iContinueGroup;   // Buttons "Next day", "More unrepeated" and "Update"

};

#endif
