#ifndef TMAINWINDOW_H
#define TMAINWINDOW_H

#include <QMainWindow>
#include <QLabel>

#include "TAppModel.h"
#include "TDictTableView.h"
#include "TFieldManager.h"

class QSignalMapper;

class TFlashcardsTestWindow;
class TSpacedRepetitionWindow;
class TVariantsTestWindow;

/**
 * The main view of the application. Displays menu, toolbar and the work area with tabs.
 */

class TMainWindow: public QMainWindow
{
Q_OBJECT

class TDictTab: public QWidget
    {
    public:
    TDictTab(TDictTableModel* aDictTableModel,  QWidget* aParent = 0 );
    ~TDictTab() { delete iDictTable->model(); }
    void SetCardSidesText( QString aQstn, QString aAnsr );
    
    QLabel* iCardSidesLabel;
    QLabel* iQstnLabel;
    QLabel* iAnsrLabel;
    TDictTableView* iDictTable;
    };

public: // Methods

TMainWindow(TAppModel* aModel);
~TMainWindow();

void LoadFile(const QString& aFilePath);

public slots:
// MVC pattern
void UpdateDictTab();
void UpdateActions();
void UpdatePasteAction();

private:    // Methods
void AddDictTab( TDictionary* aDict );
TDictTab* CurDictTab() { return static_cast< TDictTab* >( iDictTabs->currentWidget() ); }
TDictTableView* CurTableView() { TDictTab* dictTab = static_cast< TDictTab* >( iDictTabs->currentWidget() ); return dictTab? dictTab->iDictTable : NULL; }
QString ShortFileName(const QString& aFilePath);

// UI
void CreateActions();
void CreateMenus();
void CreateToolBars();
void CreateStatusBar();
void CreateCentralWidget();
void ReadSettings();
void WriteSettings();
bool DoSave( const QString& aFilePath, bool aChangeFilePath = true );  // returns: All saved and can quit now?
bool ProposeToSave();
bool ProposeToSave(int i);
void AddToRecentFiles( const QString& aFilePath);
void UpdateRecentFileActs();

// From QMainWindow
void closeEvent(QCloseEvent *event);

private slots:

void NewFile();
void Load();
bool Save();
bool SaveStudy();
bool SaveAs( bool aChangeFilePath = true );
void SaveCopy();
void Import();
void Export();
void LoadRecentFile();

void ToggleCommentInCards();
void CopyCards();
void CutCards();
void PasteCards();
void InsertCards();
void InsertCardsAfter();
void RemoveCards();
void Find();
void FindAgain();
void OpenFieldManager();
void SwapQuestionAnswer();

void StartTest(int aTestType);
void About();
void RemoveCurTab();
void UpdateCardsNumLabels();
void UpdateSelectionActions();

private:
// Data
QString iErrorTitle;
QString iAppTitle;
QString iWorkPath;  // Used in all file dialogs
QSignalMapper* iSMStartTestTriggered;
TAppModel* iModel;  // not own
QStringList iRecentFiles;
static const int KMaxRecentFiles = 9;

// UI elements
QTabWidget* iDictTabs;
QLabel* iTotalCardsLabel;
QLabel* iValidCardsLabel;
QLabel* iUnrepCardsLabel;

QMenu* iFileMenu;
QMenu* iEditMenu;
QMenu* iViewMenu;
QMenu* iToolbarsMenu;
QMenu* iFieldsMenu;
QMenu* iStudyMenu;
QMenu* iHelpMenu;
QToolBar* iFileToolBar;
QToolBar* iEditToolBar;
QToolBar* iFieldsToolBar;

// Actions
QAction* iNewAct;
QAction* iLoadAct;
QAction* iSaveAct;
QAction* iSaveAsAct;
QAction* iSaveCopyAct;
QAction* iSaveStudyAct;
QAction* iImportAct;
QAction* iExportAct;
QAction* iRemoveTabAct;
QAction* iRecentFileActs[ KMaxRecentFiles ];
QAction* iNoRecentFilesAct;
QAction* iQuitAct;

QAction* iCutAct;
QAction* iCopyAct;
QAction* iPasteAct;
QAction* iCommentAct;
QAction* iInsertCardsAct;
QAction* iInsertCardsAfterAct;
QAction* iRemoveCardsAct;
QAction* iFindAgainAct;
QAction* iFindAct;
QAction* iSwapQstnAnsrAct;
QAction* iFieldManagerAct;

QAction* iWordDrillAct;
QAction* iSpacedRepetitionAct;
QAction* iAboutAct;
QAction* iAboutQtAct;
};

#endif
