#ifndef TFINDDIALOG_H
#define TFINDDIALOG_H

#include <QDialog>
#include <QString>
#include <QModelIndex>

class QComboBox;
class QPushButton;
class QToolButton;
class QCheckBox;
class QMenu;

class TDictTableView;

/**
 * class TFindDialog
 *
 * Finds cards with the specified text.
 * Implemented as as a singleton. Once executed, it exists until the termination of the program
 * and keeps all its settings (check boxes).
 */
class TFindDialog: public QDialog
{
Q_OBJECT

public:
static int Execute(TDictTableView* aTableView, QWidget* aParent = 0);
static void FindAgain(TDictTableView* aTableView);
static bool CanFindAgain(TDictTableView* aTableView);

protected:

// From QWidget
void showEvent(QShowEvent* event);

private slots:
void FindClicked();
void UpdateFindButton();
void UpdateFromCursorCB();
void UpdateAddRegexpButton();
void AddRegexpToEdit();

private:

// Constructor
TFindDialog( QWidget* aParent = 0 );

// Methods
void SetTableView( TDictTableView* aTableView );
void Find( bool aFindAgain );
bool FindRegExp( const QRegExp& aSearchRegExp, QListIterator<QModelIndex> aStartingPoint );

// Data
static TFindDialog* iInstance;
TDictTableView* iTableView;
QString iSearchText;
QRegExp iSearchRegExp;

// GUI
QComboBox* iTextEdit;
QPushButton* iFindButton;
QPushButton* iCloseButton;
QCheckBox* iCaseSensitiveCB;
QCheckBox* iWholeWordsCB;
QCheckBox* iFromCursorCB;
QCheckBox* iUpwardsCB;
QCheckBox* iRegExpCB;
QMenu* iAddRegexpMenu;
QToolButton* iAddRegexpButton;
QCheckBox* iInSelectionCB;
QCheckBox* iInQuestionsCB;
QCheckBox* iInAnswersCB;
QCheckBox* iInExamplesCB;
QCheckBox* iInCommentsCB;
};

#endif
