#ifndef TCSVEXPORTDIALOG_H
#define TCSVEXPORTDIALOG_H

#include <QDialog>
#include <QString>

class QComboBox;
class QToolButton;
class QPushButton;
class QCheckBox;
class QSpinBox;
class QLineEdit;
class QMenu;
class QTextCodec;
class QTextEdit;
class QLabel;

class TDictionary;

/**
 * Exports dictionary to a CSV file.
 *
 * The dialog must be created and destroyed each time it is used, e.g. by creating it in the stack.
 */
class TCSVExportDialog: public QDialog
{
Q_OBJECT

public:
// Constructor
TCSVExportDialog( QWidget* aParent, const TDictionary* aDict );

void SaveCSVToFile( const QString& aFilePath );

private slots:
void AddSeparatorToEdit();
void UpdateTextDelimiterCombo();
void UpdateCommentCharacterControls();
void UpdateQuoteAllFieldsCB();
void UpdatePreview();
void UpdateCharVisibility();

private:

// Methods
QTextCodec* TextCodec();
QString SetCharVisibility( const QString& aInput, bool aVisible ) const;

// Properties
const TDictionary* iDictionary;   // not own, created here
static QChar iSpaceChar;
static QChar iTabChar;
static QString iExtendedTab;

// GUI
QComboBox* iCharacterSetCombo;
QSpinBox* iFromRowSpin; // 1-based
QLineEdit* iUsedColsEdit;
QCheckBox* iCommentsCB;
QLineEdit* iSeparatorsEdit;
QToolButton* iAddSeparatorButton;
QCheckBox* iTextDelimiterCB;
QComboBox* iTextDelimiterCombo;
QCheckBox* iQuoteAllFieldsCB;
QLabel* iCommentCharacterLabel;
QComboBox* iCommentCharacterCombo;
QTextEdit* iCSVPreview;
QCheckBox* iShowInvisibleCharsCB;
QPushButton* iOkButton;
QPushButton* iCancelButton;
QMenu* iSeparatorsMenu;
};

#endif
