#include "TAppModel.h"

#include <stdlib.h>
#include <QSignalMapper>

#include "TDictionary.h"
#include "MTestModel.h"
#include "MTestWindow.h"
#include "TFlashcardsTestModel.h"
#include "TSpacedRepetitionModel.h"
#include "TFlashcardsTestWindow.h"
#include "TSpacedRepetitionWindow.h"

// Constr and destr

TAppModel::TAppModel():
    iCurDictionary( NULL )
{
iDictionaries.clear();
for(int i=0; i<TAppModel::EToolsNum; i++)
    {
    iIsTestStarted[i] = false;
    iTestModels[i] = NULL;
    }
iSMTestModelStopped = new QSignalMapper( this );
connect( iSMTestModelStopped, SIGNAL(mapped(int)), this, SLOT(DestroyTestModel(int)) );
}

TAppModel::~TAppModel()
{
while( !iDictionaries.isEmpty() )
     delete iDictionaries.takeFirst();
for(int i=0; i<TAppModel::EToolsNum; i++)
    delete iTestModels[i];
}

// Dictionary management

QFile::FileError TAppModel::OpenDictionary( const QString& aFilePath )
{
TDictionary* dict = new TDictionary;
QFile::FileError error = dict->Load( aFilePath );
if( error == QFile::NoError )
    {
    iDictionaries << dict;
    iCurDictionary = dict;
    }
else
    {
    iErrorStr = dict->ErrorString();
    delete dict;
    }
return error;
}

void TAppModel::AddDictionary( TDictionary* aDict )
{
iDictionaries << aDict;
iCurDictionary = aDict;
}

TDictionary* TAppModel::NewDictionary()
{
TDictionary* dict = new TDictionary;
dict->SetDefaultFields();
dict->AddCard( new TCard( dict ) );
iDictionaries << dict;
iCurDictionary = dict;
return dict;
}

bool TAppModel::SetCurDictionary(int aIndex)
{
if( iDictionaries.isEmpty() )
    {
    iCurDictionary = NULL;
    return false;
    }
if( aIndex < 0 || aIndex >= iDictionaries.size())
    {
    iCurDictionary = iDictionaries[iDictionaries.size() - 1];  // Take the last one
    return false;
    }
iCurDictionary = iDictionaries[ aIndex ];
return true;
}

void TAppModel::RemoveDictionary(int aIndex)
{
if( aIndex < 0 || aIndex >= iDictionaries.size() )
    return;
delete iDictionaries.takeAt(aIndex);
SetCurDictionary( aIndex );
}

TAppModel::TError TAppModel::StartTest(int aTestType)
{
if( !iCurDictionary )
    return ENoCurDict;
if( CurDictionary()->CardsNum() == 0 )
    return EDictIsEmpty;
MTestWindow* testWindow = CreateTest( aTestType );
if( iTestModels[aTestType] && !iIsTestStarted[aTestType] )
    {
    connect( iTestModels[aTestType], SIGNAL(Stopped()), iSMTestModelStopped, SLOT(map()) );
    iSMTestModelStopped->setMapping( iTestModels[aTestType], aTestType );
    iTestModels[aTestType]->Start();
    }
testWindow->show();
if( iIsTestStarted[aTestType] )
    {
    testWindow->showNormal();
    testWindow->raise();
    testWindow->activateWindow();
    }
else
    iIsTestStarted[aTestType] = true;

return EOk;
}

void TAppModel::DestroyTestModel(int aTestType)
{
iIsTestStarted[aTestType] = false;
delete iTestModels[aTestType];  // This singleton will immediately know about destruction of its instance
iTestModels[aTestType] = NULL;
}

MTestWindow* TAppModel::CreateTest( int aTestType )
{
MTestWindow* testWindow;

switch( aTestType )
    {
    case TAppModel::EWordDrill:
        iTestModels[aTestType] = TFlashcardsTestModel::Instance( iCurDictionary );
        testWindow = TFlashcardsTestWindow::Instance( dynamic_cast<TFlashcardsTestModel*> (iTestModels[aTestType]) );
        break;
    case TAppModel::ESpacedRepetition:
        iTestModels[aTestType] = TSpacedRepetitionModel::Instance( iCurDictionary );
        testWindow = TSpacedRepetitionWindow::Instance( dynamic_cast<TSpacedRepetitionModel*> (iTestModels[aTestType]) );
        break;
    default:
        testWindow = NULL;
    }
return testWindow;
}
