#ifndef MTESTWINDOW_H
#define MTESTWINDOW_H

#include <QMainWindow>
#include <QPointer>
#include <QStatusBar>

class MTestModel;
class TCard;
class QProgressBar;
class QLabel;

class MTestWindow: public QMainWindow
{
Q_OBJECT

protected:  // Methods
// Constructor
MTestWindow( MTestModel* aModel, QWidget* parent = 0, Qt::WindowFlags flags = 0 );
// From QWidget
void closeEvent( QCloseEvent* event );

/// This function must be implemented and called in the constructor of a derived class
virtual void ReadSettings() {}

/// This function must be implemented in a derived class, but it is called from MTestWindow::closeEvent().
virtual void WriteSettings() {};

protected slots:

/// Update all window information
virtual void Update() {}

/// Update the dictionary name
virtual void UpdateDictName() {}

/// Update the displayed card. This can be a new card or just a content update.
virtual void UpdateCard( bool /*aNewCard*/ = false ) {}

/// Display the card number
virtual void DisplayCardNum() {}

void OnDictionaryRemoved();
void OnFieldsChanged();
void ShowStatusMessage() const;
void UpdateFieldLabels();

protected:

QColor iCardBackgroundColor;

// GUI
QProgressBar* iProgressBar;
QLabel* iQstnFieldLabel;
QLabel* iAnsrFieldLabel;

// Data
MTestModel* iModel;

// Cards
/// Pointer to the current card
QPointer<TCard> iCurCard;

};

#endif
