#ifndef TFLASHCARDSTESTWINDOW_H
#define TFLASHCARDSTESTWINDOW_H

#include "MTestWindow.h"
#include "MSingleton.h"

class QPushButton;
class QLabel;
class QCheckBox;
class QToolBar;
class QAction;
class TFlashcardsTestModel;

class TFlashcardsTestWindow: public MTestWindow, public MSingleton< TFlashcardsTestWindow, TFlashcardsTestModel >
{
Q_OBJECT

friend class MSingleton< TFlashcardsTestWindow, TFlashcardsTestModel >;

enum TTestState
    {
    ENoTestCards = 0,
    ENoCurCard,
    EAnswerHidden,
    EAnswerVisible,
    ENoAnswerHiddenExample,
    ENoAnswerVisibleExample
    };

protected:
// Cosntructor
TFlashcardsTestWindow(TFlashcardsTestModel* aModel);

void ReadSettings();
void WriteSettings();

protected slots:
void ToggleAnswer();

// From MTestWindow
void Update();
void UpdateDictName();
void UpdateCard( bool aNewCard = false );
void DisplayCardNum();
void UpdateButtons();

private:    // Methods
void CreateButtons();
void CreateToolBars();
void CreateCentralWidget();
QString ShortcutToStr( QKeySequence aShortcut );
void SetAnswerMode( TTestState aState );
void SetQuestionMode( TTestState aState );
void ShowAnswer( bool aVisible );

private:    // Data

// Current card
QString iCurQuestion;
QString iCurAnswer;
TTestState iState;

// UI components
QLabel* iDicNameLabel;
QLabel* iQstnLabel;
QLabel* iAnsrLabel;
QLabel* iCardNumLabel;
QLabel* iPassesIconLabel;
QLabel* iPassesLabel;
QCheckBox* iShowAnswersCB;
QPushButton* iQuitBtn;

QPushButton* iBackBtn;
QPushButton* iForwardBtn;
QPushButton* iAnsrBtn;
QPushButton* iNextBtn;
};

#endif
