#include <QLineEdit>
#include "TEditDelegate.h"

void TEditDelegate::setEditorData ( QWidget* editor, const QModelIndex& index ) const
{
QString text = index.model()->data(index, Qt::EditRole).toString();
QLineEdit* lineEdit = static_cast<QLineEdit*>(editor);
lineEdit->setText(text);
}

QWidget* TEditDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &/*option*/,
        const QModelIndex &/*index*/) const
{
QLineEdit* lineEdit = new QLineEdit(parent);
lineEdit->setFrame(false);
return lineEdit;
}

bool TEditDelegate::eventFilter(QObject *object, QEvent *event)
{
QWidget* editor = ::qobject_cast<QWidget*>(object);
if (!editor)
        return false;
if(event->type() == QEvent::KeyPress)
        {
        switch( static_cast<QKeyEvent*>(event)->key() )
                {
                case Qt::Key_Enter:
                case Qt::Key_Return:
                        emit commitData(editor);
                        emit closeEditor(editor, QAbstractItemDelegate::EditNextItem);
                        return true;
                default:
                        break;
                }
        }
return QItemDelegate::eventFilter(object, event);
}
 
