#ifndef TDICTTABLEVIEW_h
#define TDICTTABLEVIEW_h

#include <QTableView>

#include "TDictTableModel.h"

class TDictTableView: public QTableView
{
Q_OBJECT

public:

TDictTableView(QAbstractItemModel* aModel, QWidget* aParent = 0);

// Getters

// New methods
QModelIndexList Indexes() const { return model()->Indexes(); }
QModelIndexList SortedSelectedIndexes();
void ResizeColumns();

/// @return List of selected rows
QList<int> SelectedRows();

/// Expands the selection to span all columns of the selected rows
void HighlightSelectedRows();

bool Commented( const QModelIndex& aIndex ) const {return model()->Commented( aIndex ); }
bool IsEmpty( const QModelIndex& aIndex ) const {return model()->IsEmpty( aIndex ); }

// From QAbstractItemView
TDictTableModel* model() const { return static_cast<TDictTableModel*>( QTableView::model() ); }

private slots:

void EnableUpdates() { setUpdatesEnabled(true); }
void DisableUpdates() { setUpdatesEnabled(false); }

private:
static const int KMinColWidth = 170;
static const int KMaxColWidth = 400;
};

#endif 
