#ifndef TCSVIMPORTDIALOG_H
#define TCSVIMPORTDIALOG_H

#include <QDialog>
#include <QString>

class QComboBox;
class QToolButton;
class QPushButton;
class QCheckBox;
class QSpinBox;
class QLineEdit;
class QMenu;
class QTextCodec;
class QRadioButton;

class TDictTableView;
class TDictionary;
class TDictTableModel;

/**
 * Imports dictionary from a CSV file.
 *
 * The dialog must be created constructed and destroyed each time it is used, e.g. by creating it in the stack.
 */
class TCSVImportDialog: public QDialog
{
Q_OBJECT

public:
// Constructor
TCSVImportDialog( QWidget* aParent, QString aFilePath );
~TCSVImportDialog();

TDictionary* Dictionary() { return iDictionary; }

private slots:
void AddSeparatorToEdit();
void UpdateTextDelimiterCombo();
void UpdateCommentCharacterCombo();
void UpdatePreview( bool aObeyImportCols = true );
void DeleteDictionary();

private:

// Methods
QTextCodec* TextCodec();
QString FieldSeparators();

// Properties
QString iFilePath;
TDictionary* iDictionary;   // not own, created here
TDictTableModel* iPreviewModel;
static QChar iSpaceChar;
static QChar iTabChar;

// GUI
QComboBox* iCharacterSetCombo;
QSpinBox* iFromRowSpin; // 1-based
QSpinBox* iColsToImportSpin; // 1-based
QLineEdit* iSeparatorsEdit;
QToolButton* iAddSeparatorButton;
QRadioButton* iAnyCharacterRB;
QRadioButton* iAnyCombinationRB;
QRadioButton* iExactStringRB;
QCheckBox* iTextDelimiterCB;
QComboBox* iTextDelimiterCombo;
QCheckBox* iCommentCharacterCB;
QComboBox* iCommentCharacterCombo;
TDictTableView* iPreviewTable;
QPushButton* iOkButton;
QPushButton* iCancelButton;
QMenu* iSeparatorsMenu;
};

#endif
