#include "MTestWindow.h"

#include <QCloseEvent>
#include <QStatusBar>
#include <QLabel>

#include "MTestModel.h"

MTestWindow::MTestWindow( MTestModel* aModel ):
    iCardBackgroundColor( 0xff, 0xfe, 0xca ),
    iModel( aModel ), iCurCard( NULL )
{
setAttribute( Qt::WA_DeleteOnClose );
iQstnFieldLabel = new QLabel();
iQstnFieldLabel->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
iAnsrFieldLabel = new QLabel();
iAnsrFieldLabel->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
iAnsrFieldLabel->setEnabled(false);

connect( iModel, SIGNAL(CurCardNumChanged()), this, SLOT(Update()) );
connect( iModel, SIGNAL(CurPackChanged()), this, SLOT(Update()) );
/// @todo Optimize updating the modified card
connect( iModel->Dictionary(), SIGNAL(CardModified(int)), this, SLOT(UpdateCard()) );
connect( iModel->Dictionary(), SIGNAL(ContentModifiedChanged(bool)), this, SLOT(UpdateDictName()) );
connect( iModel->Dictionary(), SIGNAL(StudyModifiedChanged(bool)), this, SLOT(UpdateDictName()) );
connect( iModel->Dictionary(), SIGNAL(FilePathChanged()), this, SLOT(UpdateDictName()) );
connect( iModel->Dictionary(), SIGNAL(destroyed(QObject*)), this, SLOT(OnDictionaryRemoved()) );
connect( iModel->Dictionary(), SIGNAL(FieldsChanged()), this, SLOT(OnFieldsChanged()) );
connect( iModel, SIGNAL(ShowStatusMessage()), this, SLOT(ShowStatusMessage()) );
}

void MTestWindow::closeEvent( QCloseEvent* event )
{
if( iModel->IsStarted() )
    iModel->Stop();
WriteSettings();
event->accept();
}

void MTestWindow::OnDictionaryRemoved()
{
close();
}

void MTestWindow::OnFieldsChanged()
{
iModel->Dictionary()->SaveStudy();
iModel->Restart();
UpdateFieldLabels();
}

void MTestWindow::ShowStatusMessage() const
{
statusBar()->showMessage( iModel->StatusMessage(), 10000 );
}

void MTestWindow::UpdateFieldLabels()
{
TDictionary* dict = iModel->Dictionary();
if( !dict )
    return;
iQstnFieldLabel->setText( dict->FormattedQuestionFieldName() );
iAnsrFieldLabel->setText( dict->AnswerFieldsNames() );
}
