#include "MTestModel.h"

#include <stdlib.h>

#include <QListIterator>
#include <QMutableListIterator>

#include "TAppModel.h"
#include "TCard.h"

MTestModel::MTestModel(TDictionary* aDictionary):
    iDictionary( aDictionary ), iIsStarted( false ),
    iCurCardNum( KNoCurrentCard ), iPrevQuestion("")
{
connect( iDictionary, SIGNAL(ValidCardsRemoved()), this, SLOT(CheckCards()) );
connect( iDictionary, SIGNAL(ValidCardAdded(int)), this, SLOT(AddCard(int)) );
}

void MTestModel::Start()    /// @todo Remove special methods Start() and Restart, use the constructor instead
{
if( iIsStarted )
    return;
iFreshPack.clear();
iCardHistory.clear();
iCurCardNum = KNoCurrentCard;
iHistoryCurPackStart = 0;
iPrevQuestion.clear();
iStatusMessage.clear();
srand( time(NULL) );

GenerateFreshPack();
iIsStarted = true;
PickNextCard();
}

void MTestModel::Restart()
{
if( !iIsStarted )
    return;
iIsStarted = false;
Start();
}

void MTestModel::Stop()
{
if( !iIsStarted )
    return;
iIsStarted = false;
emit Stopped();
}

TCard* MTestModel::CurCard()
{
if( iCurCardNum < 0 || iCurCardNum >= iCardHistory.size() )
    return NULL;
return iCardHistory[ iCurCardNum ];
}

bool MTestModel::GoBack()
{
if( !CanGoBack() )
    return false;
iCurCardNum--;
emit CurCardNumChanged();
return true;
}

bool MTestModel::GoForward()
{
if( !CanGoForward() )
    return false;
iCurCardNum++;
emit CurCardNumChanged();
return true;
}

bool MTestModel::CanGoBack()
{
return iCurCardNum > 0;
}

bool MTestModel::CanGoForward()
{
return iCurCardNum < iCardHistory.size() - 1;
}

void MTestModel::CheckCards()
{
int freshSizeBefore = iFreshPack.size();
int historySizeBefore = iCardHistory.size();
for( int i=0; i < iFreshPack.size(); i++ )
    {
    TCard* card = iFreshPack.at( i );
    if( !card || !IsValidCard( card ) )
        iFreshPack.removeAt( i );
    }
for( int i=0; i < iCardHistory.size(); i++ )
    {
    TCard* card = iCardHistory.at( i );
    if( !card || !IsValidCard( card ) )
        {
        iCardHistory.removeAt( i );
        if( i < iHistoryCurPackStart )
            iHistoryCurPackStart--;
        if( i < iCurCardNum )
            iCurCardNum--;
        }
    }
if( iFreshPack.size() != freshSizeBefore || iCardHistory.size() != historySizeBefore )
    emit CurPackChanged();
}

void MTestModel::AddNewCards()
{
int sizeBefore = iFreshPack.size();
foreach( QPointer<TCard> card, iDictionary->ValidCards() )
    if( IsValidCard( card ) )
        iFreshPack << card;
if( iFreshPack.size() != sizeBefore )
    emit CurPackChanged();
}

void MTestModel::AddCard( int aIndex )
{
TCard* card = iDictionary->Card( aIndex );
if( IsValidCard( card ) )
    {
    iFreshPack << card;
    emit CurPackChanged();
    }
}

bool MTestModel::IsValidCard( const TCard* aCard ) const
{
return aCard->IsValid();   // Currently only one criterium
}

void MTestModel::PickNextCard()
{
TCard* selectedCard( NULL );

if( iFreshPack.isEmpty() )  // No fresh cards
    {
    iHistoryCurPackStart = iCardHistory.size(); // Refers beyond the history pack
    GenerateFreshPack();
    if( iFreshPack.isEmpty() )  // Still no any cards available - no useful cards in the dictionary or it's empty
        {
        iCurCardNum = KNoCurrentCard;
        emit CurCardNumChanged();
        return;
        }
    }
if( iFreshPack.size() == 1 )    // Only 1 fresh card, no choice
    selectedCard = iFreshPack.takeFirst();
else
    {
    int selectedCardNum = rand() % iFreshPack.size();
    while( iFreshPack[ selectedCardNum ]->Question() == iPrevQuestion ) // The new question must be different from the current one
        {
        selectedCardNum++;
        selectedCardNum %= iFreshPack.size();
        }
    selectedCard = iFreshPack.takeAt( selectedCardNum );
    }
iPrevQuestion = selectedCard->Question();
DisplayNextCard( selectedCard );
}

/// @todo Move MTestModel::GenerateFreshPack() into the caller code.
void MTestModel::GenerateFreshPack()
{
if( !iFreshPack.isEmpty() )
    iFreshPack.clear();
AddNewCards();
}

void MTestModel::DisplayNextCard( TCard* aCard )
{
iCardHistory << aCard;
iCurCardNum = iCardHistory.size() - 1;
emit CurCardNumChanged();
}
