#ifndef CSVDATA_H
#define CSVDATA_H

#include <QString>
#include <QChar>
#include <QList>
#include <QTextCodec>

enum TFieldSeparationMode
{
EFieldSeparatorAnyCharacter = 0,
EFieldSeparatorAnyCombination,
EFieldSeparatorExactString
};

struct TCSVImportData
{
QTextCodec* iTextCodec;
int iFromRow;
QString iFieldSeparators;
TFieldSeparationMode iFieldSeparationMode;
QChar iTextDelimiter;
QChar iCommentChar;
int iColsToImport;
};

struct TCSVExportData
{
int iFromRow;
QList<int> iUsedCols;
QString iFieldSeparators;
QChar iTextDelimiter;
bool iQuoteAllFields;
QChar iCommentChar;
};

#endif
