#include <stdlib.h>
#include <QApplication>
#include <iostream>

#include "TAppModel.h"
#include "TMainWindow.h"
#include "version.h"

int main(int argc, char *argv[])
{
setlocale(LC_ALL, "en_US.UTF-8");
QApplication app(argc, argv);
QString dictFilePath("");

QStringList argList = QCoreApplication::arguments();
QListIterator< QString > argIter( argList );
argIter.next(); // The first argument is the program calling full name
while( argIter.hasNext() )
    {
    QString argStr = argIter.next();
    if( argStr == "--version" || argStr == "-v" )
        {
        std::cout << QObject::tr("Fresh Memory "FM_VERSION"\n"
        "A utility for learning foreign words\n"
        "Author: Mykhaylo Kopytonenko\n"
        "License: GPL 2\n"
        "Websit: http://freshmemory.sourceforge.net\n").toStdString();
        return 0;
        }
    else if( argStr == "--help" || argStr == "-h" )
        {
        std::cout << QObject::tr(
        "Usage: freshmemory [OPTIONS] [FILE]\n"
        "Accepts argument FILE as a dictionary filename to load.\n\n"
        "Options:\n"
        "\t-h, --help\tDisplay this help and exit\n"
        "\t-v, --version\tOutput version information and exit\n"
        "\nReport bugs to <mishakop AT gmail.com>.\n"
        ).toStdString();
        return 0;
        }
    else if( !argIter.hasNext() )   // the last argument
        {
        dictFilePath = argStr;
        break;
        }
    }

Q_INIT_RESOURCE(application);
TAppModel model;
TMainWindow mainWin( &model );
mainWin.show();
if( !dictFilePath.isEmpty() )
    mainWin.LoadFile( dictFilePath );
return app.exec();
}
