#ifndef TSTUDYFILEPARSER_H
#define TSTUDYFILEPARSER_H

#include <QXmlDefaultHandler>
#include <QString>

#include "TDictionary.h"

class TCard;

class TStudyFileParser: public QXmlDefaultHandler
{
public:
TStudyFileParser( TDictionary* aDict );

bool startElement(const QString &namespaceURI, const QString &localName,
                const QString &qName, const QXmlAttributes &attributes);
bool endElement(const QString& /*namespaceURI*/, const QString& /*localName*/,
                const QString& /*qName*/) { return true; }
bool characters(const QString& /*str*/) { return true; }
bool fatalError(const QXmlParseException &exception);
QString errorString() const { return iErrorStr; }

private:
void PrintRepetitionData( int aCard, int aQst, int aAns, const TCard::TRepetition& aRep );

/// Not own
TDictionary* iDict;
bool iRootExists;
QString iErrorStr;
/// Not own
TCard* iCurCard;
int iCurCardIx;
QUuid iDictField0Id;
QUuid iDictField1Id;
};

#endif
