#ifndef TFIELDMANAGER_H
#define TFIELDMANAGER_H

#include <QDialog>
#include <QList>
#include <QListWidgetItem>

#include "TDictionary.h"

class QListWidget;
class QPushButton;

class TFieldManager: public QDialog
{
Q_OBJECT

public:
enum TItemRole
    {
    EFieldIdRole = Qt::UserRole,
    EFieldStyleRole
    };

TFieldManager( TDictionary* aDict, QWidget* aParent = 0 );

private slots:
void SwapQuestionAvailable();
void SwapQuestionAnswer();
void RemoveFromAnswer();
void AddToAnswer();
void MoveAnswerUp();
void MoveAnswerDown();
void FillFieldLists();
void AddField();
void RemoveField();
void RenameField();
void ToggleExampleStyle();
void SaveFields();

private:

QListWidget* AvailableList() { return iFieldLists[TDictionary::ENoneFieldRole]; }
QListWidget* QstnList() { return iFieldLists[TDictionary::EQuestionFieldRole]; }
QListWidget* AnsrList() { return iFieldLists[TDictionary::EAnswerFieldRole]; }

void CreateGUI();

// GUI
QListWidget* iFieldLists[ TDictionary::KFieldRolesNum ];
QPushButton* iSwapQstnAvailBtn;
QPushButton* iSwapQstnAnsrBtn;
QPushButton* iAnsrRemoveBtn;
QPushButton* iAnsrAddBtn;
QPushButton* iAnsrUpBtn;
QPushButton* iAnsrDownBtn;
QPushButton* iAddFieldBtn;
QPushButton* iRemoveFieldBtn;
QPushButton* iRenameFieldBtn;
QPushButton* iToggleExampleBtn;

//Data
TDictionary* iDict;
int iMaxFieldId;    /// Used for giving ids to new fields
/// List of deleted indices. They will be removed from the card fields.
QList<int> iDeletedFields;
};

#endif
