#ifndef TAPPMODEL_H
#define TAPPMODEL_H

#include <QList>
#include <QFile>

#include "TDictionary.h"

class QSignalMapper;
class TCard;
class MTestModel;
class MTestWindow;

/** The application model.
Manages the dictionaries and test models.
*/

class TAppModel: public QObject
{
Q_OBJECT

public: // Enumerations
enum TError // For starting a new test
    {
    EOk = 0,
    ENoCurDict,
    EDictIsEmpty
    };

enum TStudyToolType
    {
    EWordDrill = 0,
	ESpacedRepetition,
    EToolsNum
    };

public: // Methods

// Constr & destr
TAppModel();
~TAppModel();

// Dictionary management
QFile::FileError OpenDictionary( const QString& aFilePath );
void AddDictionary( TDictionary* aDict );
TDictionary* NewDictionary();
TDictionary* CurDictionary() const { return iCurDictionary; }
TDictionary* Dictionary(int aIndex) const { return iDictionaries[aIndex]; }
QString ErrorString() const { return iErrorStr; }

public slots:
/** @return true, if the requested dictionary was successfully set. false, if there are no dictionaries, or the index is out of range. 
 * If the dictionary list is empty, the current dictionary is set to NULL.
 * If the index is out of range, the last dictionary from the list is set.
 */
bool SetCurDictionary(int aIndex);
void RemoveDictionary(int aIndex);
TError StartTest(int aTestType);

private:    // Methods
// Tests
MTestWindow* CreateTest( int aTestType ); // Initializes iTestModels[aTestType]

private slots:
void DestroyTestModel(int aTestType);

private: // Data
QSignalMapper *iSMTestModelStopped;

// Dictionary management
QList< TDictionary* > iDictionaries;  // own
TDictionary* iCurDictionary; // not own
QString iErrorStr;

// Test
MTestModel* iTestModels[EToolsNum]; // owns
bool iIsTestStarted[EToolsNum];
};

#endif
