#ifndef MSINGLETON_H
#define MSINGLETON_H

#include <QPointer>

/**
* class MSingleton
*
* A template of the Singleton pattern.
* @arg TInstance is the instance type. It must be derived from QObject, as the singleton instance is stored using QPointer class.
* @arg TConstrArg is the type of an argument used in the singleton constructor:
* TInstance* Instance(TConstrArg* aArg).
* 
* This class is intended to be derived as a mixed-in type by a concrete singleton class. In order to confirm the classic singleton conventions, the descedant must have non-public constructor. Second, the descendant must declare instantiated class MSingleton<TInstance, TConstrArg> as its friend to share its non-public constructor.
*  The singleton instance is declared of QPointer type in order to be the guarded pointer. If someone destroys the singleton instance, the poointer iInstance will immediately be assigned to NULL.
*/

template< class TInstance, class TConstrArg >
    class MSingleton
{
public:
static TInstance* Instance(TConstrArg* aArg);
static void Destroy() { delete iInstance; } // iInstance will immediately be set to NULL because of QPointer

protected:
static QPointer<TInstance> iInstance;
};

template< class TInstance, class TConstrArg >
    QPointer<TInstance> MSingleton<TInstance, TConstrArg>::iInstance = NULL;

template< class TInstance, class TConstrArg >
    TInstance* MSingleton<TInstance, TConstrArg>::Instance(TConstrArg* aArg)
{
if( !iInstance )
    iInstance = new TInstance( aArg );
return iInstance;
}

#endif
