#ifndef TSPACEDREPETITIONMODEL_H
#define TSPACEDREPETITIONMODEL_H

#include "MTestModel.h"
#include "MSingleton.h"

#include <stdlib.h>

class TScheduleData
    {
    public:
    TScheduleData();
    
    float iDeltaE;   // delta Easiness
    float iNextInterval;   // in days
    int iAfterCards; 
    static const int KIncreasingInterval = -1;  // For iNextInterval
    static const int KAfterAllCards = -1;   // For iAfterCards
    };

/// @todo Remove the singleton template. Consider not using the singleton pattern. But make sure only 1 test window is open at a time.
class TSpacedRepetitionModel: public MTestModel, public MSingleton< TSpacedRepetitionModel, TDictionary >
{
Q_OBJECT

friend class MSingleton< TSpacedRepetitionModel, TDictionary >;

public:
static const float KMinEasiness = 1.3;
static const float KMaxEasiness = 3.2;
static const float KInitialEasiness = 2.5;
static const float KInitialInterval = 1;
static const int KGradesNum = 6;   // Min = 0
static const int KGoodGrade = 4;

protected:
TSpacedRepetitionModel( TDictionary* aDictionary );

public:
// from MTestModel
void Start();
int CurPackSize() const { return iFreshPack.size() + ActivePriorityCardsNum() + iCardHistory.size() - iHistoryCurPackStart; }
int SessionCardsNum() const;
QDateTime ActiveCardsDeadline() const { return iDictionary->ActiveCardsDeadline(); }
int UnrepeatedCardsNum() const { return iDictionary->UnrepCardsNum(); }

public slots:
    // From MTestModel:
void PickNextCard();
void Stop();
    // New:
void AddFutureActiveCards();
void UpdateActiveCards();
void AddMoreUnrepeatedCards();

protected slots:
void AddNewCards();

/// @param aNewGrade the new grade
void ScheduleCard( int aGrade );

protected:
/// An active card is a card that is due for repeating.
bool IsActiveCard( const TCard* aCard ) const;
/// How many priority cards can fit to the current fresh pack.
int ActivePriorityCardsNum() const;

protected:
/// Values for the scheduling algorithm
TScheduleData iSchedule[ KGradesNum ][ KGradesNum ];    // Params: previous and current grades

/// A pack to store prioritized cards, which must be shown after certain number of cards
TPersistentCardList iPriorityPack;

/// Day limit of used unrepeated cards
int iUnrepCardsLimit;

/** Number of today's added unrepeated cards to the fresh pack.
  * Adding unrepeated cards doesn't yet mean using them! */
int iAddedUnrepCardsNum;
};

#endif
