#include "TSpacedRepetitionModel.h"

#include <QtDebug>

TScheduleData::TScheduleData():
    iDeltaE( 0 ), iNextInterval( 0 ), iAfterCards( 0 )
{
}

TSpacedRepetitionModel::TSpacedRepetitionModel( TDictionary* aDictionary ):
    MTestModel( aDictionary ), iUnrepCardsLimit( 10 )
{
// The main grades: 2..5
for(int i=2; i < KGradesNum; i++)
    {
    iSchedule[i][5].iDeltaE = 0.1;
    iSchedule[i][4].iDeltaE = 0;
    iSchedule[i][3].iDeltaE = -0.14;
    iSchedule[i][2].iDeltaE = -0.32;
    for(int j=2; j < KGradesNum; j++)
        iSchedule[i][j].iNextInterval = TScheduleData::KIncreasingInterval;
    }
// Bad grades: 0..1
for(int i=0; i < KGradesNum; i++)
    {
    iSchedule[i][1].iDeltaE = -0.45;
    iSchedule[i][0].iDeltaE = 0;
    iSchedule[i][1].iNextInterval = 0;
    iSchedule[i][0].iNextInterval = 0;
    iSchedule[i][1].iAfterCards = TScheduleData::KAfterAllCards;
    iSchedule[i][0].iAfterCards = 7;
    }
// After bad grades
for(int i=0; i <= 1; i++)
    for(int j=2; j < KGradesNum; j++)
        {
        iSchedule[i][j].iNextInterval = 1;
        }
srand( time(NULL) );
}

void TSpacedRepetitionModel::Start()
{
// iUsedPack is not used
if( iIsStarted )
    return;
iFreshPack.clear();
iPriorityPack.clear();
iCardHistory.clear();
iCurCardNum = KNoCurrentCard;
iHistoryCurPackStart = 0;
iPrevQuestion.clear();
srand( time(NULL) );

GenerateFreshPack();
iIsStarted = true;
PickNextCard();
}

void TSpacedRepetitionModel::Stop()
{
iDictionary->SaveStudy();
MTestModel::Stop();
}

void TSpacedRepetitionModel::PickNextCard()
{
TCard* selectedCard( NULL );

// Try to find a priority card with afterCards==0
if( !iPriorityPack.isEmpty() )
    {
    QMutableListIterator< QPointer<TCard> > iter(iPriorityPack);
    int i = 0;
    while( iter.hasNext() )
        {
        TCard* card = iter.next();
        qDebug( "priority[%d]=%d", i, card->AfterCards() );
        int afterCards = card->AfterCards();
        if( afterCards <= 0 && !selectedCard )
            {
            selectedCard = card;
            iter.remove();
            qDebug( "take [%d]", i );
            }
        i++;
        }
    qDebug( "Fresh size: %d", iFreshPack.size() );
    }
if( selectedCard )
    {
    iPrevQuestion = selectedCard->Question();
    DisplayNextCard( selectedCard );
    }
else
    {
    iDictionary->SaveStudy();
    MTestModel::PickNextCard();    // Pick card from the freshpack
    }
    
// For debug:
if( CurCardIxInCurPack() >= 0 )
    {
    TCard* debugCard = iCardHistory.value( iCurCardNum );
    if( debugCard )
        qDebug() << debugCard->Question() << ":" <<  "grd/E/int(crds) =" <<
            debugCard->Grade() << "/" << debugCard->Easiness() << "/" << debugCard->Interval()
            << "(" << debugCard->AfterCards() << ")" <<
            (debugCard->Repeated()? debugCard->LastRepetition().toString("yyyy-MM-dd HH:mm:ss") : "unrepeated");
    }
}

bool TSpacedRepetitionModel::IsActiveCard( const TCard* aCard ) const
{
if( !aCard->Repeated() )
    return false;
QDateTime nextRepetition( aCard->LastRepetition().addSecs( (int)(aCard->Interval() * 60*60*24) ) );    // 1 day = 60*60*24 secs
return nextRepetition <= iDictionary->ActiveCardsDeadline();
}

void TSpacedRepetitionModel::ScheduleCard( int aNewGrade )
{
if( aNewGrade < 0 || aNewGrade >= KGradesNum )
    return;
TCard* curCard = CurCard();

// Get and check previous repetition data
TCard::TRepetition prevRep = curCard->CurRepetition();
if( prevRep.grade < 0 || prevRep.grade >= KGradesNum )
    prevRep.grade = KGoodGrade;
if( prevRep.interval < 0 )
    prevRep.interval = KInitialInterval;
if( prevRep.easiness < KMinEasiness || prevRep.easiness > KMaxEasiness )
    prevRep.easiness = KInitialEasiness;
if( !prevRep.Repeated() )
    iDictionary->DecreaseUnrepCardsNumBy( 1 );

// Form new repetition data
TCard::TRepetition newRep = prevRep;
newRep.grade = aNewGrade;
TScheduleData schedule = iSchedule[ prevRep.grade ][ newRep.grade ];
newRep.easiness = prevRep.easiness + schedule.iDeltaE;
if( newRep.easiness < KMinEasiness )
    newRep.easiness = KMinEasiness;
else if( newRep.easiness > KMaxEasiness )
    newRep.easiness = KMaxEasiness;
newRep.lastRepetition = QDateTime::currentDateTime();

if( schedule.iNextInterval == TScheduleData::KIncreasingInterval )
    {
    newRep.interval = prevRep.interval * newRep.easiness;
    float noiseRatio = 0.10 * float(rand()%200-100)/100.0;  // random noise: 10%
    newRep.interval += noiseRatio * newRep.interval;
    }
else if( schedule.iNextInterval == 0 )  // Put the card back to fresh pack
    {
    newRep.interval = 0;
    newRep.afterCards = schedule.iAfterCards;
    if( newRep.afterCards == TScheduleData::KAfterAllCards )
        {
        int allCards = iFreshPack.size() + ActivePriorityCardsNum() + 1;
        int grade0AfterCards = iSchedule[KGradesNum-1][0].iAfterCards;
        newRep.afterCards = qMax( allCards, grade0AfterCards );
        qDebug() << "\tAfter all:" << newRep.afterCards;
        }
    else
        qDebug() << "\tAfter" << newRep.afterCards;
    iPriorityPack << curCard;
    }
else
    newRep.interval = schedule.iNextInterval;
    
// Assign the new repetition data to the card
curCard->SetCurRepetition( newRep );
qDebug( "\tgrd/E/int(crds) prev=%d/%g/%g(%d) +delta=[%d]/%g/%g(%d) new=%d/%g/%g(%d) %s",
    prevRep.grade, prevRep.easiness, prevRep.interval, prevRep.afterCards,
    newRep.grade, schedule.iDeltaE, schedule.iNextInterval, schedule.iAfterCards,
    newRep.grade, newRep.easiness, newRep.interval, newRep.afterCards,
    (const char*)newRep.lastRepetition.addSecs( (int)(newRep.interval * 60*60*24) ).toString("yyyy-MM-dd HH:mm:ss").toLatin1() );
    

// Decrease afterCards parameter of priority cards
foreach( QPointer<TCard> card, iPriorityPack )
    {
    int afterCards = card->AfterCards();
    if( afterCards > 0 )
        {
        card->SetAfterCards( --afterCards );
        qDebug() << "= >" << card->AfterCards();
        }
    }
    
PickNextCard();
}

void TSpacedRepetitionModel::AddNewCards()
{
int addedActiveCards = 0;

// Add all active cards and calculate unrepeated
TPersistentCardList unrepCards;
if( iDictionary->ActiveCardsDeadline() < QDateTime::currentDateTime() )
    iDictionary->SetActiveCardsDeadline( QDateTime::currentDateTime() );
iPriorityPack.clear();
foreach( QPointer<TCard> card, iDictionary->ValidCards() )
    {
    if( card->Repeated() )
        {
        if( IsActiveCard( card ) )
            {
            if( card->Interval() == 0 ) // priority card
                iPriorityPack << card;
            else
                {
                iFreshPack << card;
                addedActiveCards++;
                }
            }
        }
    else
        unrepCards << card; /// @todo This unrep cards searching will be removed once the unrep cards proxy model is implemented.
    }

// Add unrepeated cards, if not out of limit yet
int addedUnrepCards = 0;
int sinceUnrepCardsAddition = iDictionary->UnrepCardsLastAddition().daysTo( QDateTime::currentDateTime() ); // In days
if( unrepCards.size() > 0 &&
    ( iDictionary->UsedUnrepCardsNum() < iUnrepCardsLimit || sinceUnrepCardsAddition >= 1 ) )
    {
    if( sinceUnrepCardsAddition >= 1 )
        {
        iAddedUnrepCardsNum = 0;
        iDictionary->SetUsedUnrepCardsNum( 0 );
        iDictionary->SetUnrepCardsLastAddition( QDateTime::currentDateTime() );
        }
    // Choose randomly a limited number of unrepeated cards
    int i;
    int limit = qMin( unrepCards.size(), iUnrepCardsLimit - iDictionary->UsedUnrepCardsNum() );
    for( i=0; i < limit; i++ )
        {
        TCard* card = unrepCards.takeAt( rand() % unrepCards.size() );
        iFreshPack << card;
        }
    addedUnrepCards = i;
    iAddedUnrepCardsNum += addedUnrepCards;
    if( addedUnrepCards > 0 )
        {
        qDebug() << "Added" << addedUnrepCards << "unrepeated cards";
        }
    }
    
if( addedActiveCards > 0 )
    qDebug() << "Added" << addedActiveCards << "active cards";
qDebug() << "Unrepeated:" << unrepCards.size() << "cards";

if( addedActiveCards + addedUnrepCards > 0 )
    {
    emit CurPackChanged();
    QString addedCardsMsg = tr("Added ");
    QStringList list;
    if( addedActiveCards > 0 )
        list << tr("%1 active").arg( addedActiveCards );
    if( addedUnrepCards > 0 )
        list << tr("%1 unrepeated").arg( addedUnrepCards );
    addedCardsMsg += list.join( tr(" and ") );
    addedCardsMsg += tr(" card(s)");
    iStatusMessage = addedCardsMsg;
    }
else
    iStatusMessage.clear();
emit ShowStatusMessage();
}

void TSpacedRepetitionModel::AddFutureActiveCards()
{
/// First, check if new active cards emerged by this time.
UpdateActiveCards();
if( ValidCardsNum() > 0 && iFreshPack.size() == 0 )
    {
    iDictionary->SetActiveCardsDeadline( iDictionary->ActiveCardsDeadline().addDays( 1 ) );
    iDictionary->SetUsedUnrepCardsNum( 0 );
    MTestModel::PickNextCard();
    }
}

void TSpacedRepetitionModel::AddMoreUnrepeatedCards()
{
if( iDictionary->UnrepCardsNum() > 0 && iFreshPack.size() == 0 )
    {
    iDictionary->SetUsedUnrepCardsNum( 0 );
    PickNextCard();
    }
}

void TSpacedRepetitionModel::UpdateActiveCards()
{
if( ValidCardsNum() <= 0 )
    return;
// Temporarily check for the current time
QDateTime oldActiveDeadline = iDictionary->ActiveCardsDeadline();
iDictionary->SetActiveCardsDeadline( QDateTime::currentDateTime() );
PickNextCard();
if( iFreshPack.size() == 0 )
    iDictionary->SetActiveCardsDeadline( oldActiveDeadline );
}

int TSpacedRepetitionModel::SessionCardsNum() const
{
int base = iCardHistory.size() + iFreshPack.size();
int priority = ActivePriorityCardsNum();
return base + priority;
}

int TSpacedRepetitionModel::ActivePriorityCardsNum() const
{
int freshSize = iFreshPack.size();
int activePrior = 0;
for( int i = 0; i < iPriorityPack.size(); i++ )
    {
    int afterCards = iPriorityPack[i]->AfterCards();
    if( afterCards - i - 1 <= freshSize )    // Enough fresh cards to schedule this priority card
        activePrior ++;
    }
return activePrior;    
}
