#include "TFieldManager.h"

#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QMessageBox>
#include <QListWidget>
#include <QDialogButtonBox>


TFieldManager::TFieldManager( TDictionary* aDict, QWidget* aParent ):
    QDialog( aParent ), iDict( aDict )
{
CreateGUI();
FillFieldLists();
}


/// @todo Update the buttons enableness, when selected items change. Change the Example button to a togglable tool button.
void TFieldManager::CreateGUI()
{
QHBoxLayout* ansrMoveBtnsLt = new QHBoxLayout;
ansrMoveBtnsLt->addWidget( iAnsrRemoveBtn = new QPushButton( QIcon(":/images/1leftarrow.png"), "" ) );
    iAnsrRemoveBtn->setSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Fixed );
    iAnsrRemoveBtn->setToolTip( tr("Remove field from Answer") );
    connect( iAnsrRemoveBtn, SIGNAL(clicked()), this, SLOT(RemoveFromAnswer()) );
ansrMoveBtnsLt->addWidget( iAnsrAddBtn = new QPushButton( QIcon(":/images/1rightarrow.png"), "" ) );
    iAnsrAddBtn->setSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Fixed );
    iAnsrAddBtn->setToolTip( tr("Add field to Answer") );
    connect( iAnsrAddBtn, SIGNAL(clicked()), this, SLOT(AddToAnswer()) );

QVBoxLayout* ansrUpDownBtnsLt = new QVBoxLayout;
ansrUpDownBtnsLt->addWidget( iAnsrUpBtn = new QPushButton( QIcon(":/images/1uparrow.png"), "" ) );
    iAnsrUpBtn->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::MinimumExpanding );
    iAnsrUpBtn->setToolTip( tr("Move field up") );
    connect( iAnsrUpBtn, SIGNAL(clicked()), this, SLOT(MoveAnswerUp()) );
ansrUpDownBtnsLt->addWidget( iAnsrDownBtn = new QPushButton( QIcon(":/images/1downarrow.png"), "" ) );
    iAnsrDownBtn->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::MinimumExpanding );
    iAnsrDownBtn->setToolTip( tr("Move field down") );
    connect( iAnsrDownBtn, SIGNAL(clicked()), this, SLOT(MoveAnswerDown()) );

QGridLayout* fieldsLt = new QGridLayout;
fieldsLt->addWidget( new QLabel( tr("Unused fields:") ), 0, 0 );
fieldsLt->addWidget( iFieldLists[TDictionary::ENoneFieldRole] = new QListWidget, 1, 0, 3, 1 );
fieldsLt->addWidget( iSwapQstnAvailBtn = new QPushButton( QIcon(":/images/hswap.png"), "" ), 1, 1 );
    iSwapQstnAvailBtn->setToolTip( tr("Swap Question and Unused") );
    connect( iSwapQstnAvailBtn, SIGNAL(clicked()), this, SLOT(SwapQuestionAvailable()) );
fieldsLt->addLayout( ansrMoveBtnsLt, 3, 1 );
fieldsLt->addWidget( new QLabel( tr("Question:") ), 0, 2 );
fieldsLt->addWidget( iFieldLists[TDictionary::EQuestionFieldRole] = new QListWidget, 1, 2 );
    iFieldLists[TDictionary::EQuestionFieldRole]->setFixedHeight( 25 );
fieldsLt->addWidget( new QLabel( tr("Answer:") ), 2, 2 );
fieldsLt->addWidget( iFieldLists[TDictionary::EAnswerFieldRole] = new QListWidget, 3, 2 );
fieldsLt->addWidget( iSwapQstnAnsrBtn = new QPushButton( QIcon(":/images/vswap.png"), "" ), 1, 3 );
    iSwapQstnAnsrBtn->setToolTip( tr("Swap Question and Answer") );
    connect( iSwapQstnAnsrBtn, SIGNAL(clicked()), this, SLOT(SwapQuestionAnswer()) );
fieldsLt->addLayout( ansrUpDownBtnsLt, 3, 3 );
fieldsLt->setColumnStretch( 0, 3 );
fieldsLt->setColumnStretch( 1, 1 );
fieldsLt->setColumnStretch( 2, 3 );

/// @todo Moving items
/// @todo Drag-and-drop items
/*iAnsrList->setMovement( QListView::Free );
connect( iAnsrList, SIGNAL(indexesMoved( const QModelIndexList& )), this, SLOT(ItemsMoved()) );*/

QHBoxLayout* lowBtnsLt = new QHBoxLayout;
lowBtnsLt->addWidget( iAddFieldBtn = new QPushButton( QIcon(":/images/add.png"), tr("&Add")) );
    iAddFieldBtn->setToolTip( tr("Add new field") );
    connect( iAddFieldBtn, SIGNAL(clicked()), this, SLOT(AddField()) );
lowBtnsLt->addWidget( iRemoveFieldBtn = new QPushButton( QIcon(":/images/delete.png"), tr("&Remove")) );
    iRemoveFieldBtn->setToolTip( tr("Remove field") );
    connect( iRemoveFieldBtn, SIGNAL(clicked()), this, SLOT(RemoveField()) );
lowBtnsLt->addWidget( iRenameFieldBtn = new QPushButton( QIcon(":/images/edit.png"), tr("Re&name")) );
    iRenameFieldBtn->setToolTip( tr("Rename field") );
    connect( iRenameFieldBtn, SIGNAL(clicked()), this, SLOT(RenameField()) );
lowBtnsLt->addWidget( iToggleExampleBtn = new QPushButton( QIcon(":/images/font-style.png"), tr("&Example")) );
    iToggleExampleBtn->setToolTip( tr("Toggle Example style") );
    connect( iToggleExampleBtn, SIGNAL(clicked()), this, SLOT(ToggleExampleStyle()) );

QDialogButtonBox* okCancelBox = new QDialogButtonBox( QDialogButtonBox::Ok | QDialogButtonBox::Cancel | QDialogButtonBox::Reset, Qt::Horizontal );
connect( okCancelBox, SIGNAL(accepted()), this, SLOT(SaveFields()) );
connect( okCancelBox, SIGNAL(rejected()), this, SLOT(reject()) );
connect( okCancelBox->button( QDialogButtonBox::Reset ), SIGNAL(clicked()), this, SLOT(FillFieldLists()) );

QVBoxLayout* mainLt = new QVBoxLayout;
mainLt->addLayout( fieldsLt );
mainLt->addLayout( lowBtnsLt );
mainLt->addWidget( okCancelBox );
setLayout( mainLt );

setWindowTitle(tr("Field manager"));
resize( 400, 300 );
}

void TFieldManager::FillFieldLists()
{
for( int i = 0; i < TDictionary::KFieldRolesNum; i++ )
    iFieldLists[i]->clear();
iMaxFieldId = iDict->FieldsNum() - 1;


QMapIterator<int, TField> f( iDict->Fields() );
while( f.hasNext() )
    {
    f.next();
    int fieldId = f.key();
    TField field = f.value();
    QListWidgetItem* item = new QListWidgetItem( field.name );
    item->setFlags( item->flags() | Qt::ItemIsEditable );
    item->setData( EFieldIdRole, fieldId );
    if( fieldId > iMaxFieldId )
        iMaxFieldId = fieldId;
    TField::TFieldStyle style = field.style;
    item->setData( EFieldStyleRole, style );
    QFont font = item->font();
    font.setItalic( style == TField::EExampleFieldStyle );
    item->setFont( font );
    TDictionary::TFieldRole role = iDict->FieldRole( fieldId ).first;
    iFieldLists[role]->addItem( item );
    }
iDeletedFields.clear();
}

/*void TFieldManager::ItemsMoved()
{
qDebug("ups");
}*/

void TFieldManager::SwapQuestionAvailable()
{
int availableRow = AvailableList()->currentRow();
if( availableRow < 0 || QstnList()->count() <= 0)
    return;
QListWidgetItem* availableItem = AvailableList()->takeItem( availableRow );
QListWidgetItem* qstnItem = QstnList()->takeItem( 0 );

AvailableList()->insertItem( availableRow, qstnItem );
AvailableList()->setCurrentRow( availableRow );
QstnList()->insertItem( 0, availableItem );
}

void TFieldManager::SwapQuestionAnswer()
{
int answerRow = AnsrList()->currentRow();
if( answerRow < 0 || QstnList()->count() <= 0)
    return;
QListWidgetItem* answerItem = AnsrList()->takeItem( answerRow );
QListWidgetItem* qstnItem = QstnList()->takeItem( 0 );

AnsrList()->insertItem( answerRow, qstnItem );
AnsrList()->setCurrentRow( answerRow );
QstnList()->insertItem( 0, answerItem );
}

void TFieldManager::RemoveFromAnswer()
{
int ansrRow = AnsrList()->currentRow();
if( ansrRow < 0 )
    return;

QListWidgetItem* ansrItem = AnsrList()->takeItem( ansrRow );
AvailableList()->addItem( ansrItem );
AvailableList()->setCurrentRow( AvailableList()->count() - 1 );
}

void TFieldManager::AddToAnswer()
{
int availableRow = AvailableList()->currentRow();
if( availableRow < 0 )
    return;

QListWidgetItem* availableItem = AvailableList()->takeItem( availableRow );
AnsrList()->addItem( availableItem );
AnsrList()->setCurrentRow( AnsrList()->count() - 1 );
}

void TFieldManager::MoveAnswerUp()
{
int ansrRow = AnsrList()->currentRow();
if( ansrRow - 1 < 0)
    return;

QListWidgetItem* ansrItem = AnsrList()->takeItem( ansrRow );
AnsrList()->insertItem( ansrRow - 1, ansrItem );
AnsrList()->setCurrentRow( ansrRow - 1 );
}

void TFieldManager::MoveAnswerDown()
{
int ansrRow = AnsrList()->currentRow();
if( ansrRow < 0 || ansrRow + 1 >= AnsrList()->count() )
    return;

QListWidgetItem* ansrItem = AnsrList()->takeItem( ansrRow );
AnsrList()->insertItem( ansrRow + 1, ansrItem );
AnsrList()->setCurrentRow( ansrRow + 1 );
}

/// @todo Think how to make changes to the list that just had focus.
void TFieldManager::AddField()
{
/*for( int i = TDictionary::EAnswerFieldRole; i < TDictionary::KFieldRolesNum; i++ )
    {
    QListWidget* list = iFieldLists[i];
    if( list->hasFocus() )
        {*/
        QListWidget* list = AvailableList();
        QListWidgetItem* item = new QListWidgetItem( tr("noname"), list );
        item->setFlags( item->flags() | Qt::ItemIsEditable );
        item->setData( EFieldIdRole, ++iMaxFieldId );
        item->setData( EFieldStyleRole, TField::EDefaultFieldStyle );
        list->setCurrentRow( list->count() - 1 );
        list->editItem( item );
        /*return;
        }
    }*/
}

void TFieldManager::RemoveField()
{
/*for( int i = TDictionary::EAnswerFieldRole; i < TDictionary::KFieldRolesNum; i++ )
    {
    QListWidget* list = iFieldLists[i];*/
    QListWidget* list = AvailableList();
    int row = list->currentRow();
    if( /*list->hasFocus() && */row >= 0 )
        {
        QListWidgetItem* item = list->takeItem( row );
        int deletedId = item->data( EFieldIdRole ).toInt();
        iDeletedFields << deletedId;
        delete item;
        if( deletedId == iMaxFieldId )
            iMaxFieldId--;
        return;
        }
//    }
}

void TFieldManager::RenameField()
{
/*for( int i = TDictionary::EAnswerFieldRole; i < TDictionary::KFieldRolesNum; i++ )
    {
    QListWidget* list = iFieldLists[i];*/
    QListWidget* list = AvailableList();
    int row = list->currentRow();
    if( /*list->hasFocus() && */row >= 0 )
        {
        list->editItem( list->item( row ) );
        return;
        }
//    }
}

void TFieldManager::ToggleExampleStyle()
{
/*for( int i = TDictionary::EAnswerFieldRole; i < TDictionary::KFieldRolesNum; i++ )
    {
    QListWidget* list = iFieldLists[i];*/
    QListWidget* list = AvailableList();
    int row = list->currentRow();
    if( /*list->hasFocus() && */row >= 0 )
        {
        QListWidgetItem* item = list->item( row );
        TField::TFieldStyle style = (TField::TFieldStyle)item->data( EFieldStyleRole ).toInt();
        QFont font = item->font();
        if( style == TField::EDefaultFieldStyle )
            {
            style = TField::EExampleFieldStyle;
            font.setItalic( true );
            }
        else
            {
            style = TField::EDefaultFieldStyle;
            font.setItalic( false );
            }
        item->setData( EFieldStyleRole, style );
        item->setFont( font );
        return;
        }
//    }
}

void TFieldManager::SaveFields()
{
accept();
QMap<int, TField> fields;
for( int i = 0; i < TDictionary::KFieldRolesNum; i++ )
    for( int k = 0; k < iFieldLists[i]->count(); k++ )
        {
        QListWidgetItem* item = iFieldLists[i]->item( k );
        int fieldId = item->data( EFieldIdRole ).toInt();
        TField::TFieldStyle style = TField::TFieldStyle( item->data( EFieldStyleRole ).toInt() );
        fields[fieldId] = TField( item->text(), style, iDict );
        }
QMap<int, int> ansrIxs;
for( int k = 0; k < AnsrList()->count(); k++ )
    {
    QListWidgetItem* item = AnsrList()->item( k );
    int ansIx = item->data( EFieldIdRole ).toInt();
    ansrIxs[k] = ansIx;
    }
iDict->SetCardFields( fields, QstnList()->item( 0 )->data( EFieldIdRole ).toInt(), ansrIxs, iDeletedFields);
}
