#include "TDictTableView.h"
#include "TEditDelegate.h"

#include <QtAlgorithms>

TDictTableView::TDictTableView(QAbstractItemModel* aModel, QWidget* aParent):
        QTableView( aParent )
{
setModel( aModel );
connect( aModel, SIGNAL(rowsAboutToBeInserted(const QModelIndex&, int, int)), this, SLOT(DisableUpdates()) );
connect( aModel, SIGNAL(rowsInserted(const QModelIndex&, int, int)), this, SLOT(EnableUpdates()) );
TEditDelegate* editDelegate = new TEditDelegate(this);
setItemDelegate( editDelegate );
for( int i=0; i<3; i++ )
    setColumnWidth( i, KMinColWidth );
} 

QModelIndexList TDictTableView::SortedSelectedIndexes()
{
QModelIndexList selectionList = selectedIndexes();
qSort( selectionList );
return selectionList;
}

QList<int> TDictTableView::SelectedRows()
{
QModelIndexList selectedIxs = selectedIndexes();
QList<int> selectedRows;
foreach( QModelIndex index, selectedIxs )
    if( !selectedRows.contains( index.row() ) )
        selectedRows << index.row();
return selectedRows;
}

void TDictTableView::HighlightSelectedRows()
{
selectionModel()->select( selectionModel()->selection(), QItemSelectionModel::Select | QItemSelectionModel::Rows );
}

void TDictTableView::ResizeColumns()
{
resizeColumnsToContents();
for( int i=0; i<3; i++ )
    if( columnWidth( i ) < KMinColWidth )
        setColumnWidth( i, KMinColWidth );
    else if ( columnWidth( i ) > KMaxColWidth )
        setColumnWidth( i, KMaxColWidth );
}
