#ifndef TDICTTABLEMODEL_H
#define TDICTTABLEMODEL_H

#include <QString>
#include <QList>
#include <QStringList>
#include <QAbstractTableModel>
#include <QModelIndex>

#include "TDictionary.h"
#include "TCard.h"

class TDictTableModel: public QAbstractTableModel
{
Q_OBJECT

public:
TDictTableModel( TDictionary* aDict, QObject *parent = 0 );

// Getters

// New methods
QModelIndexList Indexes() const;
QString StrValue( const QModelIndex& aIndex ) const { return data(aIndex, Qt::EditRole).toString(); }
bool IsQuestion( const QModelIndex& aIx ) const
    { return iDictionary->FieldRole( iFieldIxs[aIx.column()] ).first == TDictionary::EQuestionFieldRole; }
bool IsAnswer( const QModelIndex& aIx ) const
    { return iDictionary->FieldRole( iFieldIxs[aIx.column()] ).first == TDictionary::EAnswerFieldRole; }
bool IsExample( const QModelIndex& aIx ) const
    { return iDictionary->Field( iFieldIxs[aIx.column()] ).style == TField::EExampleFieldStyle; }
bool Commented( const QModelIndex& aIndex ) const { return iDictionary->Card( aIndex.row() )->Commented(); }
bool IsEmpty( const QModelIndex& aIndex ) const { return StrValue( aIndex ).isEmpty(); }
const TDictionary* Dictionary() const { return iDictionary; }
void SetDictionary( TDictionary* aDict ) { iDictionary = aDict; reset(); }
void DictionaryChanged();
const QModelIndex* Find( const QRegExp& aSearchRegExp,
    QListIterator<QModelIndex> aStartingPoint, bool aSearchUpwards ) const;

// From QAbstractTableModel
Qt::ItemFlags flags( const QModelIndex& index ) const { return QAbstractItemModel::flags( index ) | Qt::ItemIsEditable; }
int rowCount( const QModelIndex& parent = QModelIndex() ) const;
int columnCount( const QModelIndex& parent = QModelIndex() ) const;
QVariant data( const QModelIndex& index, int role ) const;
QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

// Setters

// New methods
/** 
 * Inserts one or more CSV rows into the dictionary.
 * @arg aPosition Row index, where to insert
 * @arg aStringList A list of CSV strings, which will be used to initialize the inserted cards.
 */
void InsertRows( int aPosition, const QStringList& aStringList );
int InsertXMLRows( int aPosition, const QString& aString );

// From QAbstractTableModel
bool setData( const QModelIndex &index, const QVariant& value, int role = Qt::EditRole );
bool insertRows( int position, int rows, const QModelIndex& index = QModelIndex() );
bool removeRows( int position, int rows, const QModelIndex& index = QModelIndex() );

private slots:
void CacheOrderedFields();

private:

TDictionary* iDictionary;       // not own
QList<int> iFieldIxs;    // cached from dictionary
};

#endif 
