#include "TDictTableModel.h"

#include <QFont>

TDictTableModel::TDictTableModel( TDictionary* aDict, QObject *parent ):
    QAbstractTableModel( parent ), iDictionary( aDict )
{
CacheOrderedFields();
connect( iDictionary, SIGNAL(FieldsChanged()), this, SLOT(CacheOrderedFields()) );
}

void TDictTableModel::CacheOrderedFields()
{
if( !iDictionary )
    return;
iFieldIxs.clear();
// Set the question
iFieldIxs << iDictionary->QuestionField();
// Set answers
foreach( int ansrIx, iDictionary->AnswerFields() )
    iFieldIxs << ansrIx;
// Add the rest
QMapIterator<int, TField> f( iDictionary->Fields() );
while( f.hasNext() )
    {
    f.next();
    int id = f.key();
    if( iDictionary->FieldRole( id ).first == TDictionary::ENoneFieldRole )
        iFieldIxs << id;
    }
reset();
}

int TDictTableModel::rowCount( const QModelIndex &/*parent*/ ) const
{
if( iDictionary )
    return iDictionary->CardsNum();
else
    return 0;
}

int TDictTableModel::columnCount(const QModelIndex &/*parent*/) const
{
return iDictionary->FieldsNum();
}

QVariant TDictTableModel::data( const QModelIndex &index, int role ) const
{
QVariant v;
if ( !iDictionary || !index.isValid() || index.row() >= rowCount() || index.column() >= columnCount() )
        return QVariant();
QPointer<TCard> card = iDictionary->Card( index.row() );
switch( role )
    {
    case Qt::DisplayRole:
    case Qt::EditRole:
        return card->Field( iFieldIxs[ index.column() ] );
    case Qt::ForegroundRole:
        if( card->Commented() )
            return Qt::blue;
        else
            return Qt::black;
    case Qt::FontRole:
        if( card->Commented() )
            {
            QFont font;
            font.setItalic( true );
            v.setValue( font );
            }
        return v;
    default:
        return QVariant();
    }
}

QVariant TDictTableModel::headerData( int section, Qt::Orientation orientation, int role ) const
{
QVariant v;
switch( role )
    {
    case Qt::DisplayRole:
        if( orientation == Qt::Vertical )
            return QString::number( section + 1 ); // 1 2 3 4 5 ...
        else // horizontal
            {
            if( section < columnCount() )
                return iDictionary->Field( iFieldIxs[section] ).name;
            else
                return QVariant();
            }
    case Qt::ForegroundRole:
        if( orientation == Qt::Vertical )
            {
            QPointer<TCard> card = iDictionary->Card( section );
            if( card && card->Commented() )
                return Qt::blue;
            }
        return Qt::black;
    case Qt::FontRole:
        if( orientation == Qt::Horizontal )
            {
            QFont font;
            font.setItalic( iDictionary->Field( iFieldIxs[section] ).style == TField::EExampleFieldStyle );
            v.setValue( font );
            }
        return v;
    default:
        return QVariant();
    }
}

bool TDictTableModel::setData( const QModelIndex &index, const QVariant &value, int role )
{
if( !index.isValid() || role != Qt::EditRole )
    return false;
int row = index.row();
int column = index.column();
if( row == rowCount() - 1 && column == columnCount() - 1 )
    insertRows( rowCount(), 1 );
QString newStrValue = value.toString();
iDictionary->SetCardField( row, iFieldIxs[column], newStrValue );
emit dataChanged( index, index );
return true;
}

bool TDictTableModel::insertRows( int position, int rows, const QModelIndex& /*parent*/ )
{
beginInsertRows( QModelIndex(), position, position + rows - 1 );
iDictionary->InsertCards( position, rows );
endInsertRows();
return true;
}

bool TDictTableModel::removeRows( int position, int rows, const QModelIndex& /*parent*/ )
{
beginRemoveRows( QModelIndex(), position, position + rows - 1 );
iDictionary->RemoveCards( position, rows );
endRemoveRows();
return true;
}

void TDictTableModel::InsertRows( int aPosition, const QStringList& aStringList )
{
beginInsertRows( QModelIndex(), aPosition, aPosition + aStringList.size() - 1 );
iDictionary->InsertCards( aPosition, aStringList );
endInsertRows();
}

int TDictTableModel::InsertXMLRows( int aPosition, const QString& aString )
{
int rowsNum = iDictionary->InsertXMLCards( aPosition, aString );    /// @todo Problem: Changing data before calling beginInsertRows()
beginInsertRows( QModelIndex(), aPosition, aPosition + rowsNum );
endInsertRows();
return rowsNum;
}

QModelIndexList TDictTableModel::Indexes() const
{
QModelIndexList indexList;
for(int r=0; r < rowCount(); r++)
    for(int c=0; c < columnCount(); c++)
        indexList << index(r, c);
return indexList;
}

void TDictTableModel::DictionaryChanged()
{
CacheOrderedFields();
reset();
}

const QModelIndex* TDictTableModel::Find( const QRegExp& aSearchRegExp,
    QListIterator<QModelIndex> aStartingPoint, bool aSearchUpwards ) const
{
while( (!aSearchUpwards)? aStartingPoint.hasNext() : aStartingPoint.hasPrevious() )
    {
    const QModelIndex* indexPtr = (!aSearchUpwards)? &(aStartingPoint.next()) : &(aStartingPoint.previous());
    if( StrValue( *indexPtr ).contains( aSearchRegExp ) )
        return indexPtr;
    }
return NULL;
}

