#ifndef TDICTPARSER_H
#define TDICTPARSER_H

#include <QXmlDefaultHandler>
#include <QString>

#include "TDictionary.h"

class TCard;

class TDictParser: public QXmlDefaultHandler
{
public:
TDictParser( TDictionary* aDict );

bool startElement(const QString &namespaceURI, const QString &localName,
                const QString &qName, const QXmlAttributes &attributes);
bool endElement(const QString &namespaceURI, const QString &localName,
                const QString &qName);
bool characters(const QString &str);
bool fatalError(const QXmlParseException &exception);
QString errorString() const { return iErrorStr; }
bool DictContentModified() const { return iDictContentModified; }

private:

/// Not own
TDictionary* iDict;
bool iRootExists;
QString iCurText;
QString iErrorStr;
/// Not own
TCard* iCurCard;
bool iDictContentModified; // Say to dictionary that it must be modified after loading
int iCurFieldIx;
QUuid iFieldId;
TField::TFieldStyle iFieldStyle;
bool iInFields;
};

#endif
