/* -*- c-basic-offset: 8 -*-
   FreeRDP: A Remote Desktop Protocol client.
   RDP protocol constants

   Copyright (C) Marc-Andre Moreau <marcandre.moreau@gmail.com> 2009

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __CONSTANTS_PDU_H
#define __CONSTANTS_PDU_H

/* X.224 TPDU Header type values */
enum X224_TPDU_TYPE
{
	X224_TPDU_CONNECTION_REQUEST = 0xE0,
	X224_TPDU_CONNECTION_CONFIRM = 0xD0,
	X224_TPDU_DISCONNECT_REQUEST = 0x80,
	X224_TPDU_DATA = 0xF0,
	X224_TPDU_ERROR = 0x70
};

/* Negotation structure types */
enum RDP_NEGOTIATION_STRUCTURES
{
	/* for X224_TPDU_CONNECTION_REQUEST: */
	TYPE_RDP_NEG_REQ = 0x1,
	/* for X224_TPDU_CONNECTION_CONFIRM: */
	TYPE_RDP_NEG_RSP = 0x2,
	TYPE_RDP_NEG_FAILURE = 0x3
};

/* T.125 PDU types, index value in PER encoding */
enum T125_DOMAINMCSPDU_PER_INDEX
{
	T125_DOMAINMCSPDU_ErectDomainRequest = 1,
	T125_DOMAINMCSPDU_DisconnectProviderUltimatum = 8,
	T125_DOMAINMCSPDU_AttachUserRequest = 10,
	T125_DOMAINMCSPDU_AttachUserConfirm = 11,
	T125_DOMAINMCSPDU_ChannelJoinRequest = 14,
	T125_DOMAINMCSPDU_ChannelJoinConfirm = 15,
	T125_DOMAINMCSPDU_SendDataRequest = 25,
	T125_DOMAINMCSPDU_SendDataIndication = 26
};

/* RDP Share Control Header pduType */
enum RDP_PDU_TYPE
{
	RDP_PDU_DEMAND_ACTIVE = 1,
	RDP_PDU_CONFIRM_ACTIVE = 3,
	RDP_PDU_DEACTIVATE_ALL = 6,
	RDP_PDU_DATA = 7,
	RDP_PDU_SERVER_REDIR_PKT = 10
};

/* RDP Share Data Header pduType2 */
enum RDP_DATA_PDU_TYPE
{
	RDP_DATA_PDU_UPDATE = 2,
	RDP_DATA_PDU_CONTROL = 20,
	RDP_DATA_PDU_POINTER = 27,
	RDP_DATA_PDU_INPUT = 28,
	RDP_DATA_PDU_SYNCHRONIZE = 31,
	/* RDP_DATA_PDU_REFRESH_RECT = 33, */
	RDP_DATA_PDU_PLAY_SOUND = 34,
	RDP_DATA_PDU_SUPPRESS_OUTPUT = 35,
	/* RDP_DATA_PDU_SHUTDOWN_REQUEST = 36, */
	/* RDP_DATA_PDU_SHUTDOWN_DENIED = 37, */
	RDP_DATA_PDU_SAVE_SESSION_INFO = 38,
	RDP_DATA_PDU_FONTLIST = 39,
	/* RDP_DATA_PDU_FONTMAP = 40, */
	RDP_DATA_PDU_SET_KEYBOARD_INDICATORS = 41,
	RDP_DATA_PDU_SET_ERROR_INFO = 47
};

/* RDP Control PDU Data actions */
enum RDP_CONTROL_PDU_TYPE
{
	RDP_CTL_REQUEST_CONTROL = 1,
	RDP_CTL_GRANTED_CONTROL = 2,
	RDP_CTL_DETACH = 3,
	RDP_CTL_COOPERATE = 4
};

/* RDP Slow-Path Graphics Update updateType */
enum RDP_UPDATE_PDU_TYPE
{
	RDP_UPDATE_ORDERS = 0,
	RDP_UPDATE_BITMAP = 1,
	RDP_UPDATE_PALETTE = 2,
	RDP_UPDATE_SYNCHRONIZE = 3
};

/* RDP Server Pointer Update messageType */
enum RDP_POINTER_PDU_TYPE
{
	RDP_PTRMSGTYPE_SYSTEM = 1,
	RDP_PTRMSGTYPE_POSITION = 3,
	RDP_PTRMSGTYPE_COLOR = 6,
	RDP_PTRMSGTYPE_CACHED = 7,
	RDP_PTRMSGTYPE_POINTER = 8
};

/* RDP System Pointer Update systemPointerType */
enum RDP_SYSTEM_POINTER_TYPE
{
	RDP_SYSPTR_NULL = 0,
	RDP_SYSPTR_DEFAULT = 0x7F00
};

/* RDP Server Redirection Packet RedirFlags */
enum RDP_REDIR_FLAGS
{
	LB_TARGET_NET_ADDRESS = 0x00000001,
	LB_LOAD_BALANCE_INFO = 0x00000002,
	LB_USERNAME = 0x00000004,
	LB_DOMAIN = 0x00000008,
	LB_PASSWORD = 0x00000010,
	LB_DONTSTOREUSERNAME = 0x00000020,
	LB_SMARTCARD_LOGON = 0x00000040,
	LB_NOREDIRECT = 0x00000080,
	LB_TARGET_FQDN = 0x00000100,
	LB_TARGET_NETBIOS_NAME = 0x00000200,
	LB_TARGET_NET_ADDRESSES = 0x00000800
};

/* Set Error Info PDU Data errorInfo */
enum RDP_ERRORINFO
{
	/* Protocol-independent codes: */
	ERRINFO_RPC_INITIATED_DISCONNECT = 0x0001,
	ERRINFO_RPC_INITIATED_LOGOFF = 0x0002,
	ERRINFO_IDLE_TIMEOUT = 0x0003,
	ERRINFO_LOGON_TIMEOUT = 0x0004,
	ERRINFO_DISCONNECTED_BY_OTHERCONNECTION = 0x0005,
	ERRINFO_OUT_OF_MEMORY = 0x0006,
	ERRINFO_SERVER_DENIED_CONNECTION = 0x0007,
	ERRINFO_SERVER_INSUFFICIENT_PRIVILEGES = 0x0009,
	ERRINFO_SERVER_FRESH_CREDENTIALS_REQUIRED = 0x000A,
	ERRINFO_RPC_INITIATED_DISCONNECT_BYUSER = 0x000B,
	/* Protocol-independent licensing codes: */
	ERRINFO_LICENSE_INTERNAL = 0x0100,
	ERRINFO_LICENSE_NO_LICENSE_SERVER = 0x0101,
	ERRINFO_LICENSE_NO_LICENSE = 0x0102,
	ERRINFO_LICENSE_BAD_CLIENT_MSG = 0x0103,
	ERRINFO_LICENSE_HWID_DOESNT_MATCH_LICENSE = 0x0104,
	ERRINFO_LICENSE_BAD_CLIENT_LICENSE = 0x0105,
	ERRINFO_LICENSE_CANT_FINISH_PROTOCOL = 0x0106,
	ERRINFO_LICENSE_CLIENT_ENDED_PROTOCOL = 0x0107,
	ERRINFO_LICENSE_BAD_CLIENT_ENCRYPTION = 0x0108,
	ERRINFO_LICENSE_CANT_UPGRADE_LICENSE = 0x0109,
	ERRINFO_LICENSE_NO_REMOTE_CONNECTIONS = 0x010A,
	/* RDP specific codes: */
	ERRINFO_UNKNOWNPDUTYPE2 = 0x10C9,
	ERRINFO_UNKNOWNPDUTYPE = 0x10CA,
	ERRINFO_DATAPDUSEQUENCE = 0x10CB,
	ERRINFO_CONTROLPDUSEQUENCE = 0x10CD,
	ERRINFO_INVALIDCONTROLPDUACTION = 0x10CE,
	ERRINFO_INVALIDINPUTPDUTYPE = 0x10CF,
	ERRINFO_INVALIDINPUTPDUMOUSE = 0x10D0,
	ERRINFO_INVALIDREFRESHRECTPDU = 0x10D1,
	ERRINFO_CREATEUSERDATAFAILED = 0x10D2,
	ERRINFO_CONNECTFAILED = 0x10D3,
	ERRINFO_CONFIRMACTIVEWRONGSHAREID = 0x10D4,
	ERRINFO_CONFIRMACTIVEWRONGORIGINATOR = 0x10D5,
	ERRINFO_PERSISTENTKEYPDUBADLENGTH = 0x10DA,
	ERRINFO_PERSISTENTKEYPDUILLEGALFIRST = 0x10DB,
	ERRINFO_PERSISTENTKEYPDUTOOMANYTOTALKEYS = 0x10DC,
	ERRINFO_PERSISTENTKEYPDUTOOMANYCACHEKEYS = 0x10DD,
	ERRINFO_INPUTPDUBADLENGTH = 0x10DE,
	ERRINFO_BITMAPCACHEERRORPDUBADLENGTH = 0x10DF,
	ERRINFO_SECURITYDATATOOSHORT = 0x10E0,
	ERRINFO_VCHANNELDATATOOSHORT = 0x10E1,
	ERRINFO_SHAREDATATOOSHORT = 0x10E2,
	ERRINFO_BADSUPRESSOUTPUTPDU = 0x10E3,
	ERRINFO_CONFIRMACTIVEPDUTOOSHORT = 0x10E5,
	ERRINFO_CAPABILITYSETTOOSMALL = 0x10E7,
	ERRINFO_CAPABILITYSETTOOLARGE = 0x10E8,
	ERRINFO_NOCURSORCACHE = 0x10E9,
	ERRINFO_BADCAPABILITIES = 0x10EA,
	ERRINFO_VIRTUALCHANNELDECOMPRESSIONERR = 0x10EC,
	ERRINFO_INVALIDVCCOMPRESSIONTYPE = 0x10ED,
	ERRINFO_INVALIDCHANNELID = 0x10EF,
	ERRINFO_VCHANNELSTOOMANY = 0x10F0,
	ERRINFO_REMOTEAPPSNOTENABLED = 0x10F3,
	ERRINFO_CACHECAPNOTSET = 0x10F4,
	ERRINFO_BITMAPCACHEERRORPDUBADLENGTH2 = 0x10F5,
	ERRINFO_OFFSCRCACHEERRORPDUBADLENGTH = 0x10F6,
	ERRINFO_DNGCACHEERRORPDUBADLENGTH = 0x10F7,
	ERRINFO_GDIPLUSPDUBADLENGTH = 0x10F8,
	ERRINFO_SECURITYDATATOOSHORT2 = 0x1111,
	ERRINFO_SECURITYDATATOOSHORT3 = 0x1112,
	ERRINFO_SECURITYDATATOOSHORT4 = 0x1113,
	ERRINFO_SECURITYDATATOOSHORT5 = 0x1114,
	ERRINFO_SECURITYDATATOOSHORT6 = 0x1115,
	ERRINFO_SECURITYDATATOOSHORT7 = 0x1116,
	ERRINFO_SECURITYDATATOOSHORT8 = 0x1117,
	ERRINFO_SECURITYDATATOOSHORT9 = 0x1118,
	ERRINFO_SECURITYDATATOOSHORT10 = 0x1119,
	ERRINFO_SECURITYDATATOOSHORT11 = 0x111A,
	ERRINFO_SECURITYDATATOOSHORT12 = 0x111B,
	ERRINFO_SECURITYDATATOOSHORT13 = 0x111C,
	ERRINFO_SECURITYDATATOOSHORT14 = 0x111D,
	ERRINFO_SECURITYDATATOOSHORT15 = 0x111E,
	ERRINFO_SECURITYDATATOOSHORT16 = 0x111F,
	ERRINFO_SECURITYDATATOOSHORT17 = 0x1120,
	ERRINFO_SECURITYDATATOOSHORT18 = 0x1121,
	ERRINFO_SECURITYDATATOOSHORT19 = 0x1122,
	ERRINFO_SECURITYDATATOOSHORT20 = 0x1123,
	ERRINFO_SECURITYDATATOOSHORT21 = 0x1124,
	ERRINFO_SECURITYDATATOOSHORT22 = 0x1125,
	ERRINFO_SECURITYDATATOOSHORT23 = 0x1126,
	ERRINFO_BADMONITORDATA = 0x1129,
	ERRINFO_UPDATESESSIONKEYFAILED = 0x1191,
	ERRINFO_DECRYPTFAILED = 0x1192,
	ERRINFO_ENCRYPTFAILED = 0x1193,
	ERRINFO_ENCPKGMISMATCH = 0x1194,
	ERRINFO_DECRYPTFAILED2 = 0x1195
};

/* RDP Persistent Key List PDU Data bBitMask */
enum RDP_BITMAPCACHE_PERSISTENT_SEQ
{
	BITMAP_PERSIST_FLAG_FIRST = 0x01,
	BITMAP_PERSIST_FLAG_LAST = 0x02
};

#endif /* __CONSTANTS_PDU_H */
