# Configure paths for Hildon
# Sergey Udaltsov 2008

dnl AM_PATH_HILDON([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for Hildon, and define HILDON_CFLAGS and HILDON_LIBS, if gthread is specified in MODULES, 
dnl pass to pkg-config
dnl
AC_DEFUN([AM_PATH_HILDON],
[dnl 
dnl Get the cflags and libraries from pkg-config
dnl

  pkg_config_args="hildon-1 hildon-fm-2 libosso"

  no_hildon=""

  AC_PATH_PROG(PKG_CONFIG, pkg-config, no)

  if test x$PKG_CONFIG != xno ; then
    if pkg-config --atleast-pkgconfig-version 0.7 ; then
      :
    else
      echo *** pkg-config too old; version 0.7 or better required.
      no_hildon=yes
      PKG_CONFIG=no
    fi
  else
    no_hildon=yes
  fi

  min_hildon_version=ifelse([$1], ,1.0.0,$1)
  AC_MSG_CHECKING(for Hildon - version >= $min_hildon_version)

  if test x$PKG_CONFIG != xno ; then
    ## don't try to run the test against uninstalled libtool libs
    if $PKG_CONFIG --uninstalled $pkg_config_args; then
	  echo "Will use uninstalled version of Hildon found in PKG_CONFIG_PATH"
    fi

    if $PKG_CONFIG --atleast-version $min_hildon_version $pkg_config_args; then
	  :
    else
	  no_hildon=yes
    fi
  fi

  if test x"$no_hildon" = x ; then
    HILDON_CFLAGS=`$PKG_CONFIG $pkg_config_args --cflags`
    HILDON_LIBS=`$PKG_CONFIG $pkg_config_args --libs`

    hildon_config_major_version=`$PKG_CONFIG --modversion hildon-1 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    hildon_config_minor_version=`$PKG_CONFIG --modversion hildon-1 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    hildon_config_micro_version=`$PKG_CONFIG --modversion hildon-1 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
 
  fi

  if test "x$no_hildon" = x ; then
     AC_MSG_RESULT(yes (version $hildon_config_major_version.$hildon_config_minor_version.$hildon_config_micro_version))
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$PKG_CONFIG" = "no" ; then
       echo "*** A new enough version of pkg-config was not found."
       echo "*** See http://pkgconfig.sourceforge.net"
     else
       echo "*** Could not run Hildon test program, checking why..."
       ac_save_CFLAGS="$CFLAGS"
       ac_save_LIBS="$LIBS"
       CFLAGS="$CFLAGS $HILDON_CFLAGS"
       LIBS="$LIBS $HILDON_LIBS"
       AC_TRY_LINK([
       #include <hildon/hildon.h>
       #include <stdio.h>
       ],      [ return ((hildon_major_version) || (hildon_minor_version) || (hildon_micro_version)); ],
       [ echo "*** The test program compiled, but did not run. This usually means"
         echo "*** that the run-time linker is not finding Hildon or finding the wrong"
         echo "*** version of Hildon. If it is not finding Hildon, you'll need to set your"
         echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
         echo "*** to the installed location  Also, make sure you have run ldconfig if that"
         echo "*** is required on your system"
         echo "***"
         echo "*** If you have an old version installed, it is best to remove it, although"
         echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
       [ echo "*** The test program failed to compile or link. See the file config.log for the"
         echo "*** exact error that occured. This usually means Hildon is incorrectly installed."])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
     HILDON_CFLAGS=""
     HILDON_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(HILDON_CFLAGS)
  AC_SUBST(HILDON_LIBS)
])
