/**********************************************************************
 Freeciv - Copyright (C) 1996 - A Kjeldberg, L Gregersen, P Unold
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
***********************************************************************/
#ifndef FC__MAPTOOLS_H
#define FC__MAPTOOLS_H

#include <gtk/gtk.h>

typedef struct _MapTools MapTools;
typedef struct _MapToolBar MapToolBar;
typedef struct _MapToolBarButton MapToolBarButton;

struct _MapTools;
struct _MapToolBar;
struct _MapToolBarButton;

MapTools *map_tools_new(void);

void map_tools_set_tool_bar(MapTools *mt, MapToolBar *tb);

/* Prevent the map tools being overwritten */
/* Return false if there is no overlap anyway */
gboolean map_tools_clip_out(MapTools *mt,
			    GdkDrawable *drawable,
			    GdkGC *gc,
			    gint x,
			    gint y,
			    gint width,
			    gint height);

/* Remove the clipping from map_tools_clip_out and draw all the tools */
void map_tools_unclip_and_draw(MapTools *mt,
			       GdkDrawable *drawable,
			       GdkGC *gc,
			       gint x,
			       gint y,
			       gint width,
			       gint height);

gboolean map_tools_button_down(MapTools *mt, GdkEventButton *ev, gpointer data);

gboolean map_tools_button_release(MapTools *mt,
				  GdkEventButton *ev,
				  gpointer data);

MapToolBar *map_tool_bar_new(void);

void map_tool_bar_add_button(MapToolBar *tb, MapToolBarButton *bb);

typedef void (*MapToolBarButtonCallback)(MapToolBarButton *bb, gpointer data);

MapToolBarButton *map_tool_bar_button_new(const gchar *file_stem,
					  MapToolBarButtonCallback cb,
					  gpointer data);

void map_tool_bar_button_enable(MapToolBarButton *bb);
void map_tool_bar_button_disable(MapToolBarButton *bb);
void map_tool_bar_button_highlight_on(MapToolBarButton *bb);
void map_tool_bar_button_highlight_off(MapToolBarButton *bb);

#endif /* #ifndef FC__MAPTOOLS_H */
