#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>
#include "logindialog.h"
#include <QMessageBox>
#include <QLabel>
#include <QtGui/QMenuBar>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ps = PositionSource::instance();
    ui->setupUi(this);
    s = new Settings();
    if(s->getSetting("token")=="")
    {
        LoginDialog ld(this);
        ld.exec();
    }

    fsc = FoursquareComm::instance();

    if(s->getSetting("userid")=="")
    {
        f_user u = fsc->getUser();
        s->setSetting("userid",u.id);
    }
    ui->pbFriends->setVisible(false); //TODO

    QAction *aboutAction = new QAction(tr("About"), this);
    menuBar()->addAction(aboutAction);
    connect(aboutAction,SIGNAL(triggered()),this,SLOT(showAbout()));

    QAction *donateAction = new QAction(tr("Like this app?"), this);
    menuBar()->addAction(donateAction);
    connect(donateAction,SIGNAL(triggered()),this,SLOT(showDonate()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pbSearchVenue_clicked()
{
    svw = new SearchVenuesWindow(this);
    svw->show();
}

void MainWindow::on_pbLeaderboard_clicked()
{
    lb = new LeaderBoard(this);
    lb->show();
}

void MainWindow::on_pbRecent_clicked()
{
    rcw = new RecentCheckinsWindow(this);
    rcw->show();
}

void MainWindow::on_pbTips_clicked()
{
    ntf = new NearbyTipsForm(this);
    ntf->show();
}

void MainWindow::showAbout()
{
    QMessageBox::information(this,"About FourCircle","<b>FourCircle</b><br>By Ted van den Brink<br><a href=\"mailto:ted@digistate.nl\">ted@digistate.nl</a><br>Thanks at:<br>Gilamonyet for the icon");
}

void MainWindow::showDonate()
{
    QMessageBox::information(this,"Do you like FourCircle?","<b>FourCircle</b><br>I have put <i>way</i> too much time in this application.<br>If you like it, please consider to <a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=PR2UCTL83HD7G\">donate!</a> (PayPal)<br>The more you donate, the more features will be available soon!");
}
