#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>
#include "logindialog.h"

#include <QLabel>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ps = PositionSource::instance();
    ui->setupUi(this);
    s = new Settings();
    if(s->getSetting("token")=="")
    {
        LoginDialog ld(this);
        ld.exec();
    }

    fsc = FoursquareComm::instance();

    if(s->getSetting("userid")=="")
    {
        f_user u = fsc->getUser();
        s->setSetting("userid",u.id);
    }

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pbSearchVenue_clicked()
{
    svw = new SearchVenuesWindow(this);
    svw->show();
}

void MainWindow::on_pbLeaderboard_clicked()
{
    lb = new LeaderBoard(this);
    lb->show();
}

void MainWindow::on_pbRecent_clicked()
{
    rcw = new RecentCheckinsWindow(this);
    rcw->show();
}

void MainWindow::on_pbTips_clicked()
{
    ntf = new NearbyTipsForm(this);
    ntf->show();
}
