#ifndef FOURSQUARECOMM_H
#define FOURSQUARECOMM_H
#include <QObject>
#include <QStringList>
#include <QList>
#include "oauth.h"
#include <QScriptValue>
#include <QMap>

struct f_location {
    QString address; //"Gravin Adelheidlaan"
    QString city; // "Nieuwegein"
    QString state; // "Utrecht"
    QString postalCode; //"3434DA"
    QString lat; // 52.012478
    QString lng; // 5.09570972063
    QString crossStreet;
    int distance; //8
};

struct f_category {
    QString id; //: "4bf58dd8d48988d103941735"
    QString name; // "Home"
    QString pluralName; // "Homes"
    QString icon; // "https://foursquare.com/img/categories/building/home.png"
    QString parents[]; //      "Homes, Work, Others"
    bool primary; //: true
};

struct f_user {
    QString id;
    QString firstName;
    QString lastName;
    QString homeCity;
    QString photo;
    QString gender;
    QString relationship;
    //detailed user
    bool extendedInfo;
    QString type;
};

struct f_venue {
    QString id;
    QString name;
    QString contactTwitter;
    QString contactPhone;
    QString parents[];
    QString icon;
    f_location location;
    QList<f_category> categories;
    bool verified;
    int checkinsCount; //161
    int usersCount; // 3
    int todosCount; // 0
    int hereNowCount; // 0
    //extended venue details
    bool extendedInfo;
    QString description;
    f_user mayor;
    int mayorCheckinCount;
    QString stats;
    QString tips;
    QString todos;
    QString tags;
    QString beenHere;
    QString shortUrl;
    QString specialsNearby;
    QString photos;
};
Q_DECLARE_METATYPE(f_venue);

struct f_checkin {
    QString id;
    QString type;
    QString privateCheckin;
    f_user user;
    QString timeZone;
    f_venue venue;
    QString location;
    QString shout;
    QString createdAt;
    QString source;
    QString photos;
    QString comments;
    QString overlaps;
};

struct f_checkinresult {
    QString type;
    QMap<QString,QString> values;
};

struct f_tip {
    QString id;
    QString createdAt;
    QString text;
    QString url;
    //TODO: todo en done
    f_venue venue;
    f_user user;
};

class FoursquareComm: public QObject
{
    Q_OBJECT
private:
    oAuth * oa;
    f_venue itemToVenue(QScriptValue qv, bool extended = false);
    f_checkinresult itemToCheckinresult(QScriptValue qv);
    f_user itemToUser(QScriptValue qv, bool extended = false);
    static FoursquareComm *inst;
    f_checkin itemToCheckin(QScriptValue qv);
    QString doRequest(QString a);
    f_tip itemToTip(QScriptValue qv);
protected:
    FoursquareComm();
public:
    static FoursquareComm *instance();
    QList<f_checkin> getRecentCheckins();
    QList<f_venue> searchVenues(QString ll, QString llAcc = QString(""), QString query = QString(""));
    QList<f_checkinresult> checkinVenue(QString venueId, QString shout, QString broadcast, QString ll, QString llAcc="");
    f_venue addVenue(QString name, QString address, QString crossStreet, QString city, QString state, QString zip, QString phone, QString ll, QString primaryCategoryId="");
    f_venue getVenue(QString id);
    f_user getUser(QString id = "self");
    QList<f_tip> getNearbyTips(QString ll);
signals:
    void venueReady(f_venue);
};

#endif // FOURSQUARECOMM_H
