#ifndef SEARCHVENUESWINDOW_H
#define SEARCHVENUESWINDOW_H

#include <QWidget>
#include "foursquarecomm.h"
#include "positionsource.h"
#include "venuedetails.h"
#include <QModelIndex>
#include "imagecache.h"

QTM_USE_NAMESPACE

namespace Ui {
    class SearchVenuesWindow;
}

class SearchVenuesWindow : public QWidget
{
    Q_OBJECT

public:
    explicit SearchVenuesWindow(QWidget *parent = 0);
    ~SearchVenuesWindow();

private:
    Ui::SearchVenuesWindow *ui;
    FoursquareComm * fsc;
    PositionSource * ps;
    QList<f_venue> lastResult;
    VenueDetails * vd;
    ImageCache * ic;
    void parseAndShowResult();

private slots:
    void on_listWidget_clicked(QModelIndex index);
    void on_pbNearby_clicked();
    void on_pbSearch_clicked();
};

#endif // SEARCHVENUESWINDOW_H
